% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_nodes_from_table.R
\name{add_nodes_from_table}
\alias{add_nodes_from_table}
\title{Add nodes and attributes to graph from a table}
\usage{
add_nodes_from_table(graph, table, label_col = NULL, type_col = NULL,
  set_type = NULL, drop_cols = NULL)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}

\item{table}{either a path to a CSV file, or, a data
frame object.}

\item{label_col}{an option to apply a column of data
in the table as \code{label} attribute values.}

\item{type_col}{an option to apply a column of data
in the table as \code{type} attribute values.}

\item{set_type}{an optional string to apply a
\code{type} attribute to all nodes created from the
table records.}

\item{drop_cols}{an optional character vector for
dropping columns from the incoming data.}
}
\value{
a graph object of class \code{dgr_graph}.
}
\description{
Add nodes and their attributes to an
existing graph object from data in a CSV file or a
data frame.
}
\examples{
\dontrun{
library(dplyr)

# Specify a path to a CSV file
path_to_csv <-
  system.file(
    "extdata", "currencies.csv",
    package = "DiagrammeR")

# To add nodes from a CSV file, call the
# `add_nodes_from_table()` function; new node ID
# values will be created as a monotonically-
# increasing values from 1
graph_1 <-
  create_graph() \%>\%
  add_nodes_from_table(
    table = path_to_csv)

# View part of the graph's internal node data
# frame (ndf) using `get_node_df()`
graph_1 \%>\%
  get_node_df() \%>\%
  .[, 1:5] \%>\%
  head()
#>   id type label iso_4217_code curr_number
#> 1  1 <NA>  <NA>           AED         784
#> 2  2 <NA>  <NA>           AFN         971
#> 3  3 <NA>  <NA>           ALL           8
#> 4  4 <NA>  <NA>           AMD          51
#> 5  5 <NA>  <NA>           ANG         532
#> 6  6 <NA>  <NA>           AOA         973

# If you would like to assign any of the table's
# columns as `type` or `label` attributes, this can
# be done with the `type_col` and `label_col`
# arguments; to set a static `type` attribute for
# all of the table records, use `set_type`
graph_2 <-
  create_graph() \%>\%
  add_nodes_from_table(
    table = path_to_csv,
    label_col = iso_4217_code,
    set_type = "currency")

# View part of the graph's internal ndf
graph_2 \%>\%
  get_node_df() \%>\%
  .[, 1:5] \%>\%
  head()
#>   id     type label iso_4217_code curr_number
#> 1  1 currency   AED           AED         784
#> 2  2 currency   AFN           AFN         971
#> 3  3 currency   ALL           ALL           8
#> 4  4 currency   AMD           AMD          51
#> 5  5 currency   ANG           ANG         532
#> 6  6 currency   AOA           AOA         973

# Suppose you would like to not include certain
# columns from the table in the resulting graph; you
# can use the `drop_cols` argument to choose which
# columns to not include as attributes in the graph
graph_3 <-
  create_graph() \%>\%
  add_nodes_from_table(
    table = path_to_csv,
    label_col = iso_4217_code,
    set_type = "currency",
    drop_cols = c("exponent", "currency_name"))

# Show the node attribute names for the graph
graph_3 \%>\%
  get_node_df() \%>\%
  colnames()
#> [1] "id"  type"  "label"  "iso_4217_code"
#> [5] "curr_number"
}
}
