% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_gnp_graph.R
\name{add_gnp_graph}
\alias{add_gnp_graph}
\title{Add a G(n, p) Erdos-Renyi graph}
\usage{
add_gnp_graph(graph, n, p, loops = FALSE)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}

\item{n}{the number of nodes comprising the
generated graph.}

\item{p}{the probability of creating an edge
between two arbitrary nodes.}

\item{loops}{a logical value (default is
\code{FALSE}) that governs whether loops are
allowed to be created.}
}
\description{
To an existing graph object, add
a graph built according to the Erdos-Renyi
G(n, p) model, which uses a constant probability
when creating edges.
}
\examples{
# Create an undirected GNP
# graph with 100 nodes using
# a probability value of 0.05
gnp_graph <-
  create_graph(
    directed = FALSE) \%>\%
  add_gnp_graph(
    n = 100,
    p = 0.05)

# Get a count of nodes
gnp_graph \%>\% node_count()
#> [1] 100

# Get a count of edges
gnp_graph \%>\% edge_count()
#> [1] 216
}
