% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rename_node_attrs.R
\name{rename_node_attrs}
\alias{rename_node_attrs}
\title{Rename a node attribute}
\usage{
rename_node_attrs(graph, node_attr_from, node_attr_to)
}
\arguments{
\item{graph}{A graph object of class \code{dgr_graph}.}

\item{node_attr_from}{The name of the node attribute that will be renamed.}

\item{node_attr_to}{The new name of the node attribute column identified in
\code{node_attr_from}.}
}
\value{
A graph object of class \code{dgr_graph}.
}
\description{
Within a graph's internal node data frame (ndf), rename an existing node
attribute.
}
\examples{
# Create a random graph using the
# `add_gnm_graph()` function
graph <-
  create_graph() \%>\%
  add_gnm_graph(
    n = 5,
    m = 8,
    set_seed = 23) \%>\%
  set_node_attrs(
    node_attr = shape,
    values = "circle") \%>\%
  set_node_attrs(
    node_attr = value,
    values = rnorm(
      n = count_nodes(.),
      mean = 5,
      sd = 1) \%>\% round(1))

# Get the graph's internal ndf
# to show which node attributes
# are available
graph \%>\% get_node_df()

# Rename the `value` node
# attribute as `weight`
graph <-
  graph \%>\%
  rename_node_attrs(
    node_attr_from = value,
    node_attr_to = weight)

# Get the graph's internal
# ndf to show that the node
# attribute had been renamed
graph \%>\% get_node_df()

}
