% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recode_node_attrs.R
\name{recode_node_attrs}
\alias{recode_node_attrs}
\title{Recode a set of node attribute values}
\usage{
recode_node_attrs(
  graph,
  node_attr_from,
  ...,
  otherwise = NULL,
  node_attr_to = NULL
)
}
\arguments{
\item{graph}{A graph object of class \code{dgr_graph}.}

\item{node_attr_from}{The name of the node attribute column from which values
will be recoded.}

\item{...}{Single-length character vectors with the recoding instructions.
The first component should have the value to replace and the second should
have the replacement value (in the form \verb{"[to_replace] -> [replacement]", ...}).}

\item{otherwise}{An optional single value for recoding any unmatched values.}

\item{node_attr_to}{An optional name of a new node attribute to which the
recoded values will be applied. This will retain the original node
attribute and its values.}
}
\value{
A graph object of class \code{dgr_graph}.
}
\description{
Within a graph's internal node data frame (ndf), recode character or numeric
node attribute values. Optionally, one can specify a replacement value for
any unmatched mappings.
}
\examples{
# Create a random graph using the
# `add_gnm_graph()` function
graph <-
  create_graph() \%>\%
  add_gnm_graph(
    n = 5,
    m = 10,
    set_seed = 23) \%>\%
  set_node_attrs(
    node_attr = shape,
    values =
      c("circle", "hexagon",
        "rectangle", "rectangle",
        "circle"))

# Get the graph's internal ndf
# to show which node
# attributes are available
graph \%>\% get_node_df()

# Recode the `shape` node
# attribute, so that `circle`
# is recoded to `square` and that
# `rectangle` becomes `triangle`
graph <-
  graph \%>\%
  recode_node_attrs(
    node_attr_from = shape,
    "circle -> square",
    "rectangle -> triangle")

# Get the graph's internal
# ndf to show that the node
# attribute values had been recoded
graph \%>\% get_node_df()

# Create a new node attribute,
# called `color`, that is based
# on a recoding of `shape`; here,
# map the square shape to a `red`
# color and map all other shapes
# to a `green` color
graph <-
  graph \%>\%
  recode_node_attrs(
    node_attr_from = shape,
    "square -> red",
    otherwise = "green",
    node_attr_to = color)

# Get the graph's internal ndf
# to see the change
graph \%>\% get_node_df()

}
\seealso{
Other Node creation and removal: 
\code{\link{add_n_node_clones}()},
\code{\link{add_n_nodes_ws}()},
\code{\link{add_n_nodes}()},
\code{\link{add_node_clones_ws}()},
\code{\link{add_node_df}()},
\code{\link{add_nodes_from_df_cols}()},
\code{\link{add_nodes_from_table}()},
\code{\link{add_node}()},
\code{\link{colorize_node_attrs}()},
\code{\link{copy_node_attrs}()},
\code{\link{create_node_df}()},
\code{\link{delete_nodes_ws}()},
\code{\link{delete_node}()},
\code{\link{drop_node_attrs}()},
\code{\link{join_node_attrs}()},
\code{\link{layout_nodes_w_string}()},
\code{\link{mutate_node_attrs_ws}()},
\code{\link{mutate_node_attrs}()},
\code{\link{node_data}()},
\code{\link{rename_node_attrs}()},
\code{\link{rescale_node_attrs}()},
\code{\link{set_node_attr_to_display}()},
\code{\link{set_node_attr_w_fcn}()},
\code{\link{set_node_attrs_ws}()},
\code{\link{set_node_attrs}()},
\code{\link{set_node_position}()}
}
\concept{Node creation and removal}
