% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_smallworld_graph.R
\name{add_smallworld_graph}
\alias{add_smallworld_graph}
\title{Add a Watts-Strogatz small-world graph}
\usage{
add_smallworld_graph(
  graph,
  dimension,
  size,
  neighborhood,
  p,
  loops = FALSE,
  multiple = FALSE,
  type = NULL,
  label = TRUE,
  rel = NULL,
  node_aes = NULL,
  edge_aes = NULL,
  node_data = NULL,
  edge_data = NULL,
  set_seed = NULL
)
}
\arguments{
\item{graph}{A graph object of class \code{dgr_graph}.}

\item{dimension}{The dimension of the starting lattice.}

\item{size}{The size of the lattice across each dimension.}

\item{neighborhood}{The neighborhood where the lattice nodes are to be
connected.}

\item{p}{The rewiring probability.}

\item{loops}{A logical value (default is \code{FALSE}) that governs whether loops
are allowed to be created.}

\item{multiple}{A logical value (default is \code{FALSE}) that governs whether
multiple edges are allowed to be created.}

\item{type}{An optional string that describes the entity type for all the
nodes to be added.}

\item{label}{A logical value where setting to \code{TRUE} ascribes node IDs to the
label and \code{FALSE} yields a blank label.}

\item{rel}{An optional string for providing a relationship label to all edges
to be added.}

\item{node_aes}{An optional list of named vectors comprising node aesthetic
attributes. The helper function \code{\link[=node_aes]{node_aes()}} is strongly recommended for
use here as it contains arguments for each of the accepted node aesthetic
attributes (e.g., \code{shape}, \code{style}, \code{color}, \code{fillcolor}).}

\item{edge_aes}{An optional list of named vectors comprising edge aesthetic
attributes. The helper function \code{\link[=edge_aes]{edge_aes()}} is strongly recommended for
use here as it contains arguments for each of the accepted edge aesthetic
attributes (e.g., \code{shape}, \code{style}, \code{penwidth}, \code{color}).}

\item{node_data}{An optional list of named vectors comprising node data
attributes. The helper function \code{\link[=node_data]{node_data()}} is strongly recommended for
use here as it helps bind data specifically to the created nodes.}

\item{edge_data}{An optional list of named vectors comprising edge data
attributes. The helper function \code{\link[=edge_data]{edge_data()}} is strongly recommended for
use here as it helps bind data specifically to the created edges.}

\item{set_seed}{Supplying a value sets a random seed of the
\code{Mersenne-Twister} implementation.}
}
\value{
A graph object of class \code{dgr_graph}.
}
\description{
To an existing graph object, add a graph built according to the
Watts-Strogatz small-world model, which uses a lattice along with a rewiring
probability to randomly modify edge definitions.
}
\examples{
# Create an undirected smallworld
# graph with 100 nodes using
# a probability value of 0.05
smallworld_graph <-
  create_graph(
    directed = FALSE) \%>\%
  add_smallworld_graph(
    dimension = 1,
    size = 50,
    neighborhood = 1,
    p = 0.05,
    set_seed = 23)

# Get a count of nodes
smallworld_graph \%>\% count_nodes()

# Get a count of edges
smallworld_graph \%>\% count_edges()

}
