% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TempDisaggToolbox.R
\name{TempDisaggToolbox}
\alias{TempDisaggToolbox}
\title{Low-Dimensional Temporal Disaggregation Toolbox}
\usage{
TempDisaggToolbox(
  Y,
  X = matrix(data = rep(1, times = nrow(Y)), nrow = nrow(Y)),
  method = "Denton-Cholette",
  aggMat = "sum",
  Denton = "first"
)
}
\arguments{
\item{Y}{The low-frequency response vector.}

\item{X}{The high-frequency indicator matrix.}

\item{method}{Disaggregation using 'Denton', 'Denton-Cholette', 'Chow-Lin', 'Fernandez', 'Litterman'.}

\item{aggMat}{Aggregation matrix according to 'first', 'sum', 'average', 'last'.}

\item{Denton}{The 'absolute', 'first', 'second' and 'proportional' difference Sigma for the Denton method.}
}
\value{
y_Est	Estimated high-frequency response series.

beta_Est	Estimated coefficient vector.

rho_Est	Estimated residual autocorrelation parameter.

ul_Est	Estimated aggregate residual series.
}
\description{
This function contains the movement preservation and regression-based low-dimensional temporal disaggregation methods proposed by \insertCite{denton1971adjustment;textual}{DisaggregateTS}, \insertCite{dagum2006benchmarking;textual}{DisaggregateTS}
\insertCite{chow1971best;textual}{DisaggregateTS}, \insertCite{fernandez1981methodological;textual}{DisaggregateTS} and \insertCite{litterman1983random;textual}{DisaggregateTS}.
}
\examples{
data = TempDisaggDGP(n_l=50,m=4,p=4,method='Chow-Lin',rho=0.5)
X = data$X_Gen
Y = data$Y_Gen
fit_chowlin = TempDisaggToolbox(Y=Y,X=X,method='Chow-Lin')
y_hat = fit_chowlin$y_Est
}
\references{
\insertAllCited{}
}
\keyword{Chow-Lin}
\keyword{Denton}
\keyword{Denton-Cholette}
\keyword{Fernandez}
\keyword{Litterman}
\keyword{temporal-disaggregation}
