% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HYPERPO2.R
\name{HYPERPO2}
\alias{HYPERPO2}
\title{The hyper Poisson family (with mu as mean)}
\usage{
HYPERPO2(mu.link = "log", sigma.link = "log")
}
\arguments{
\item{mu.link}{defines the mu.link, with "log" link as the default for the mu parameter.}

\item{sigma.link}{defines the sigma.link, with "log" link as the default for the sigma.}
}
\value{
Returns a \code{gamlss.family} object which can be used
to fit a hyper-Poisson distribution version 2
in the \code{gamlss()} function.
}
\description{
The function \code{HYPERPO2()} defines the hyper Poisson distribution, a two parameter
distribution, for a \code{gamlss.family} object to be used in GAMLSS fitting
using the function \code{gamlss()}.
}
\details{
The hyper-Poisson distribution with parameters \eqn{\mu} and \eqn{\sigma}
has a support 0, 1, 2, ...

Note: in this implementation the parameter \eqn{\mu} is the mean
of the distribution and \eqn{\sigma} corresponds to
the dispersion parameter. If you fit a model with this parameterization,
the time will increase because an internal procedure to convert \eqn{\mu}
to \eqn{\lambda} parameter.
}
\examples{
# Example 1
# Generating some random values with
# known mu and sigma
set.seed(1234)
y <- rHYPERPO2(n=200, mu=3, sigma=0.5)

# Fitting the model
library(gamlss)
mod1 <- gamlss(y~1, sigma.fo=~1, family=HYPERPO2,
               control=gamlss.control(n.cyc=500, trace=FALSE))

# Extracting the fitted values for mu and sigma
# using the inverse link function
exp(coef(mod1, what='mu'))
exp(coef(mod1, what='sigma'))

# Example 2
# Generating random values under some model

\donttest{
# A function to simulate a data set with Y ~ HYPERPO2
gendat <- function(n) {
  x1 <- runif(n)
  x2 <- runif(n)
  mu    <- exp(1.21 - 3 * x1) # 0.75 approximately
  sigma <- exp(1.26 - 2 * x2) # 1.30 approximately
  y <- rHYPERPO2(n=n, mu=mu, sigma=sigma)
  data.frame(y=y, x1=x1, x2=x2)
}

set.seed(1234)
datos <- gendat(n=500)

mod2 <- NULL
mod2 <- gamlss(y~x1, sigma.fo=~x2, family=HYPERPO2, data=datos,
               control=gamlss.control(n.cyc=500, trace=FALSE))

summary(mod2)
}
}
\references{
\insertRef{saez2013hyperpo}{DiscreteDists}
}
\seealso{
\link{dHYPERPO2}, \link{HYPERPO}.
}
\author{
Freddy Hernandez, \email{fhernanb@unal.edu.co}
}
