# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#'@title Kernel functions
#'@name kernel
#'
#'@description
#'Kernel functions that transform observed p-values or their support according
#'to [HSU], [HSD], [AHSU], [AHSD] and [HBR-\eqn{\lambda}]. The output is used
#'by \code{\link{discrete.BH}} or \code{\link{DBR}}, respectively.
#'Additionally, \code{kernel.DBH.crit}, \code{kernel.ADBH.crit} and
#'\code{kernel.DBR.crit} compute and return the critical constants. The end
#'user should not use these functions directly.
#'
#'@details
#'When computing critical constants under step-down, that is, when using
#'\code{kernel.DBH.crit}, \code{kernel.ADBH.crit} or \code{kernel.DBR.crit}
#'with \code{stepUp = FALSE} (i.e. the step-down case), we still need to get
#'transformed p-values to compute the adjusted p-values.
#'
#'This version: 2019-07-13.
#'
#'@seealso
#'\code{\link{discrete.BH}}, \code{\link{DiscreteFDR}},
#'\code{\link{DBR}}
#'
#'@templateVar pCDFlist TRUE
#'@templateVar stepf FALSE
#'@templateVar pvalues TRUE
#'@templateVar stepUp TRUE
#'@templateVar alpha TRUE
#'@templateVar lambda TRUE
#'@templateVar support TRUE
#'@templateVar sorted_pv TRUE
#'@templateVar raw.pvalues FALSE
#'@templateVar direction FALSE
#'@templateVar ret.crit.consts FALSE
#'@templateVar adaptive FALSE
#'@template param 
#'
#'@template example
#'@examples
#'
#'alpha <- 0.05
#'
#'# Compute the step functions from the supports
#'
#'# We stay in a step-down context, where pv.numer = pv.denom,
#'# for the sake of simplicity
#'
#'# If not searching for critical constants, we use only the observed p-values
#'sorted.pvals <- sort(raw.pvalues)
#'y.DBH.fast <- kernel_DBH_fast(pCDFlist, sorted.pvals)
#'y.ADBH.fast <- kernel_ADBH_fast(pCDFlist, sorted.pvals)
#'# transformed values
#'y.DBH.fast
#'y.ADBH.fast
#'
#'# compute transformed support
#'pv.list <- sort(unique(unlist(pCDFlist)))
#'y.DBH.crit <- kernel_DBH_crit(pCDFlist, pv.list, sorted.pvals)
#'y.ADBH.crit <- kernel_ADBH_crit(pCDFlist, pv.list, sorted.pvals)
#'y.DBR.crit <- kernel_DBR_crit(pCDFlist, pv.list, sorted.pvals)
#'# critical constants
#'y.DBH.crit$crit.consts
#'y.ADBH.crit$crit.consts
#'y.DBR.crit$crit.consts
#'# The following exist only for step-down direction or DBR
#'y.DBH.crit$pval.transf
#'y.ADBH.crit$pval.transf
#'y.DBR.crit$pval.transf
#'
#'@return
#'For \code{kernel.DBH.fast}, \code{kernel.ADBH.fast} and
#'\code{kernel.DBR.fast}, a vector of transformed p-values is returned.
#'\code{kernel.DBH.crit,} \code{kernel.ADBH.crit} and \code{kernel.DBR.crit}
#'return a list object with critical constants (\code{$crit.consts}) and
#'transformed p-values (\code{$pval.transf}), but if \code{stepUp = FALSE},
#'there are critical values only.
NULL

#'@rdname kernel
#'@export
kernel_DBH_fast <- function(pCDFlist, pvalues, stepUp = FALSE, alpha = 0.05, support = 0L) {
    .Call('_DiscreteFDR_kernel_DBH_fast', PACKAGE = 'DiscreteFDR', pCDFlist, pvalues, stepUp, alpha, support)
}

#'@rdname kernel
#'@export
kernel_DBH_crit <- function(pCDFlist, pvalues, sorted_pv, stepUp = FALSE, alpha = 0.05) {
    .Call('_DiscreteFDR_kernel_DBH_crit', PACKAGE = 'DiscreteFDR', pCDFlist, pvalues, sorted_pv, stepUp, alpha)
}

#'@rdname kernel
#'@export
kernel_ADBH_fast <- function(pCDFlist, pvalues, stepUp = FALSE, alpha = 0.05, support = 0L) {
    .Call('_DiscreteFDR_kernel_ADBH_fast', PACKAGE = 'DiscreteFDR', pCDFlist, pvalues, stepUp, alpha, support)
}

#'@rdname kernel
#'@export
kernel_ADBH_crit <- function(pCDFlist, pvalues, sorted_pv, stepUp = FALSE, alpha = 0.05) {
    .Call('_DiscreteFDR_kernel_ADBH_crit', PACKAGE = 'DiscreteFDR', pCDFlist, pvalues, sorted_pv, stepUp, alpha)
}

#'@rdname kernel
#'@export
kernel_DBR_fast <- function(pCDFlist, pvalues, lambda = 0.05) {
    .Call('_DiscreteFDR_kernel_DBR_fast', PACKAGE = 'DiscreteFDR', pCDFlist, pvalues, lambda)
}

#'@rdname kernel
#'@export
kernel_DBR_crit <- function(pCDFlist, pvalues, sorted_pv, lambda = 0.05, alpha = 0.05) {
    .Call('_DiscreteFDR_kernel_DBR_crit', PACKAGE = 'DiscreteFDR', pCDFlist, pvalues, sorted_pv, lambda, alpha)
}

