% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hypergeo.R
\name{Erl}
\alias{Erl}
\alias{expValErl}
\alias{varErl}
\title{Hypergeometric Distribution}
\usage{
expValErl(N = n + m, m, n = N - m, k)

varErl(N = n + m, m, n = N - m, k)
}
\arguments{
\item{N}{Total number of balls (white and black) in the urn. \eqn{N = n + m}{N = n + m}}

\item{m}{Number of white balls in the urn.}

\item{n}{Number of black balls in the urn. Can specify n instead of N.}

\item{k}{Number of balls drawn from the urn, k = 0, 1, ..., m + n.}
}
\value{
Function :
  \itemize{
    \item{\code{\link{expValErl}}}{ gives the expected value.}
    \item{\code{\link{varErl}}}{ gives the variance.}
  }
 Invalid parameter values will return an error detailing which parameter is problematic.
}
\description{
Hypergeometric distribution where we have a sample of k balls from an urn
containing N, of which m are white and n are black.
}
\details{
The Hypergeometric distribution for \eqn{N}{N} total items of which
\eqn{m}{m} are of one type and \eqn{n}{n} of the other and from which
\eqn{k}{k} items are picked has probability mass function :
  \deqn{Pr(X = x) = \frac{\left(\frac{m}{k}\right)\left(\frac{n}{k - x}\right)}{\left(\frac{N}{k}\right)}}{((m)C(k) (n)C(k - x)) / ((N)C(k))}
for \eqn{x = 0, 1, \dots, \min(k, m)}{x = 0, 1, ..., min(k, m)}.
}
\examples{

# With total balls specified
expValErl(N = 5, m = 2, k = 2)

# With number of each colour of balls specified
expValErl(m = 2, n = 3, k = 2)


# With total balls specified
varErl(N = 5, m = 2, k = 2)

# With number of each colour of balls specified
varErl(m = 2, n = 3, k = 2)

}
