% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method-export.R
\name{CloudPrivateServer}
\alias{CloudPrivateServer}
\title{Define the data object for a cloud private server}
\usage{
CloudPrivateServer(
  publicIp = character(0),
  publicPort = integer(0),
  privateIp = character(0),
  privatePort = integer(0),
  password = "",
  serverWorkerSameLAN = FALSE,
  serverClientSameLAN = FALSE
)
}
\arguments{
\item{publicIp}{Character(0) or Character(1), the public Ip of the server}

\item{publicPort}{Integer(0) or Integer(1), the public port of the server}

\item{privateIp}{Character(0) or Character(1), the private Ip of the server}

\item{privatePort}{Integer(0) or Integer(1), the private port of the server}

\item{password}{Character(1), the password for the server}

\item{serverWorkerSameLAN}{Logical(1), whether the server and works are in the same LAN}

\item{serverClientSameLAN}{Logical(1), whether the server and client are in the same LAN}
}
\description{
Define the data object for a cloud private server. The data object
can be passed to \code{makeDockerCluster} and let the cluster
use the private server instead of the server from the cloud provider.
}
\examples{
CloudPrivateServer(publicIp = "192.168.1.1", publicPort = 1234)
}
