% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/HillQuantileEstimator.R
\name{HillQuantileEstimator}
\alias{HillQuantileEstimator}
\title{Hill Quantile Estimator}
\usage{
HillQuantileEstimator(Ra, tail.index, in.sample.prob, cl)
}
\arguments{
\item{Ra}{A data set}

\item{tail.index}{Assumed tail index}

\item{in.sample.prob}{In-sample probability (used as basis for projection)}

\item{cl}{Confidence level}
}
\value{
Value of Hill Quantile Estimator
}
\description{
Estimates value of Hill Quantile Estimator for a specified data set, tail
index, in-sample probability and confidence level.
}
\examples{
# Computes estimates value of hill estimator for a specified data set
   Ra <- rnorm(1000)
   HillQuantileEstimator(Ra, 40, .5, .9)
}
\author{
Dinesh Acharya
}
\references{
Dowd, K. Measuring Market Risk, Wiley, 2007.

Next reference
}

