% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelEval.R
\name{clean.mcmc}
\alias{clean.mcmc}
\title{Post-process an MCMC list with reflection issues}
\usage{
clean.mcmc(N, P, D, coda.fit, rotation, real.W, real.B)
}
\arguments{
\item{N}{number of individuals}

\item{P}{number of variables}

\item{D}{number of latent factors}

\item{coda.fit}{an MCMC list}

\item{rotation}{a DxD rotation matrix}

\item{real.W}{a reference latent factor matrix}

\item{real.B}{a reference factor loadings matrix}
}
\value{
mc.simu a clean MCMC list corrected for reflection issues
}
\description{
Post-process an MCMC list with reflection issues
}
\examples{
data(toydata) # simulated data
data(stanfit) # output of modelFit or main.modelFit
coda.fit <- coda.obj(stanfit)

data.simul <- toydata$Y.simul$Y
N = nrow(data.simul)
D = toydata$wlu$D
P = ncol(data.simul)
## PCA in the histogram basis
obs <- toydata$X
times <- toydata$t
pca.data <- pca.Deville(obs, times, t.range = c(min(times), max(times)), breaks = 15)
## Post-processing landmark information
rotation <- toydata$wlu$Q # rotation matrix
real.W <- toydata$wlu$W # PCA-determined latent factors
real.B <- t(pca.data$Cp[, 1:(toydata$wlu$D)]) # PCA-determined scores
codafit.clean <- clean.mcmc(N, P, D, coda.fit, rotation, real.W, real.B)
head(codafit.clean)

}
\author{
Gabrielle Weinrott
}

