% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simul.R
\name{pca.proj.Xt}
\alias{pca.proj.Xt}
\title{PCA data projected onto a histogram basis}
\usage{
pca.proj.Xt(X, t, t.range = c(0, 1000), breaks = 15)
}
\arguments{
\item{X}{the data matrix}

\item{t}{the matrix of observation times}

\item{t.range}{a vector specifying the observation time range (default : c(0, 1000))}

\item{breaks}{the number of breaks in the histogram basis (default : breaks = 15)}
}
\value{
Xt.proj a matrix of projected observations

U a matrix of eigenvectors

lambda a vector of eigenvalues

lambda.perc the percentage of inertia captured by each axis
}
\description{
PCA data projected onto a histogram basis
}
\examples{
res <- drbats.simul(N = 5, P = 100, t.range = c(5, 100), breaks = 8)
pca.proj.Xt(res$X, res$t.simul, t.range = c(0, 100), breaks = 8)

}
\author{
Gabrielle Weinrott
}

