% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/require.R
\name{requirePriorDrugWashout}
\alias{requirePriorDrugWashout}
\title{Restrict cohort to only cohort records with a given amount of time since the
last cohort record ended}
\usage{
requirePriorDrugWashout(
  cohort,
  days,
  cohortId = NULL,
  name = omopgenerics::tableName(cohort)
)
}
\arguments{
\item{cohort}{A cohort table in a cdm reference.}

\item{days}{The number of days required to have passed since the last cohort
record finished. Any records with fewer days than this will be dropped. Note
that setting days to Inf will lead to the same result as that from using the
\code{requireIsFirstDrugEntry} function (with only an individual´s first cohort
record kept).}

\item{cohortId}{IDs of the cohorts to modify. The default is NULL meaning all
cohorts will be used; otherwise, only the specified cohorts will be modified,
and the rest will remain unchanged.}

\item{name}{Name of the table with the filtered cohort records. The default
name is the original cohort name, where the original table will be
overwritten.}
}
\value{
The cohort table having applied the washout requirement.
}
\description{
Filter the cohort table keeping only the cohort records for which the
required amount of time has passed since the last cohort entry ended for that
individual.
}
\examples{
\donttest{
library(DrugUtilisation)
library(dplyr)

cdm <- mockDrugUtilisation()

cdm$cohort1 <- cdm$cohort1 |>
  requirePriorDrugWashout(days = 90)

attrition(cdm$cohort1) |> glimpse()
}

}
