% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summariseDrugRestart.R
\name{summariseDrugRestart}
\alias{summariseDrugRestart}
\title{Summarise the drug restart per window.}
\usage{
summariseDrugRestart(
  cohort,
  switchCohortTable,
  switchCohortId = NULL,
  strata = list(),
  followUpDays = Inf,
  censorDate = NULL,
  restrictToFirstDiscontinuation = TRUE
)
}
\arguments{
\item{cohort}{A cohort table.}

\item{switchCohortTable}{A cohort table in the cdm that contains possible
alternative treatments.}

\item{switchCohortId}{The cohort ids to be used from switchCohortTable. If
NULL all cohort definition ids are used.}

\item{strata}{List with column names or vectors of column names groups to
stratify results by.}

\item{followUpDays}{A vector of number of days to follow up. It can be
multiple values.}

\item{censorDate}{Date of censoring. Individuals are always censored at the
end of observation.}

\item{restrictToFirstDiscontinuation}{Whether to consider only the first
discontinuation episode or all of them.}
}
\value{
A summarised_result object with the percentages of restart, switch
and not exposed per window.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\examples{
\donttest{
library(DrugUtilisation)

cdm <- mockDrugUtilisation()

conceptlist <- list("a" = 1125360, "b" = c(1503297, 1503327))
cdm <- generateDrugUtilisationCohortSet(
  cdm = cdm,
  name = "switch_cohort",
  conceptSet = conceptlist
)

result <- cdm$cohort1 |>
  summariseDrugRestart(switchCohortTable = "switch_cohort")

tableDrugRestart(result)

CDMConnector::cdmDisconnect(cdm = cdm)
}
}
