% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/APIMtoTrans.R
\name{APIMtoTrans}
\alias{APIMtoTrans}
\title{APIMtoTrans}
\usage{
APIMtoTrans(B0_1, AE_1, PE_1, Int_1, B0_2, AE_2, PE_2, Int_2)
}
\arguments{
\item{B0_1}{Intercept if the first sequence is the dependent variable}

\item{AE_1}{Actor-Effect if the first sequence is the dependent variable}

\item{PE_1}{Partner-Effect if the first sequence is the dependent variable}

\item{Int_1}{Actor*Partner-Intercation-Effect if the first sequence is the dependent variable}

\item{B0_2}{Intercept if the second sequence is the dependent variable}

\item{AE_2}{Actor-Effect if the second sequence is the dependent variable}

\item{PE_2}{Partner-Effect if the second sequence is the dependent variable}

\item{Int_2}{Actor*Partner-Intercation-Effect if the second sequence is the dependent variable}
}
\value{
myTrans a transition matrix
}
\description{
Transforms APIM beta-coefficients into an equivalent transition matrix. 
(only implemented for binary dyadic sequences!)
}
\examples{

trans1<-APIMtoTrans(B0_1=0.1, AE_1=0.2, PE_1=0.3, Int_1=0.4,
                   B0_2=0.5, AE_2=0.6, PE_2=0.7, Int_2=0.8)

#inspecting the equivalent matrix
trans1

#backtesting by transforming the matrix back into beta-coefficients
round(TransToAPIM(trans1),6)

}
