\name{.newRWL}
\docType{methods}
\alias{.newRWL}
\alias{.newRWL,modelObj,modelObj-method}

\title{ Residual Weighted Learning.}

\description{
Estimates the optimal treatment regime using residual weighted learning.
}

\usage{
.newRWL(moPropen, moMain, ...)
\S4method{.newRWL}{modelObj,modelObj}(moPropen, moMain, data, response, txName, regime, lambdas, cvFolds, 
        kernel, kparam, responseType, txVec, guess, suppress)
}

\arguments{
 \item{moPropen}{\code{"modelObj"} for propensity score regression.}
 \item{moMain}{\code{"modelObj"} for outcome regression.}
 \item{...}{Used to pass arguments that are required but
            the class of which does not determine the
            method that is selected.}
 \item{data    }{\code{"data.frame"} of covariates and treatment history.}
 \item{response  }{Outcome of interest.}
 \item{txName  }{Treatment variable column header in \code{data}.}
 \item{regime  }{\code{"formula"} description of decision function.}
 \item{lambdas }{Tuning parameter(s).}
 \item{cvFolds }{Number of cross-validation folds.}
 \item{kernel  }{\code{"character"} description of kernel function.}
 \item{kparam  }{\code{"numeric"} parameter for kernel function.}
 \item{responseType}{\code{"character"} indicating if outcome is continuous
                     or count data.}
 \item{txVec   }{Treatment vector recast as +/- 1.}
 \item{guess}{Inital parameter guesses for optimization routine.}
 \item{suppress}{T/F indicating if prints to screen are executed.}
}

\author{
  Shannon T. Holloway <sthollow@ncsu.edu>
}

\examples{

data(bmiData)

y <- -(bmiData$month12BMI - bmiData$month4BMI) / bmiData$month4BMI * 100

moPropen <- buildModelObj(model = ~1, 
                          solver.method = 'glm',
                          solver.args = list("family" = "binomial"),
                          predict.args = list("type" = "response"))

moMain <- buildModelObj(model = ~ parentBMI + baselineBMI + month4BMI, 
                        solver.method = 'lm')

regime <- ~ parentBMI + baselineBMI + gender

txVec <- numeric(nrow(bmiData)) - 1L
txVec[bmiData$A2 == "MR"] <- 1L
bmiData$A2 <- as.factor(bmiData$A2)
\dontrun{
obj <- DynTxRegime:::.newRWL(moPropen = moPropen,
                             moMain = moMain,
                             data = bmiData,
                             response = y,
                             txName = "A2",
                             regime = regime,
                             lambdas = 0.1,
                             cvFolds = 0L,
                             kernel = "linear",
                             kparam = NULL,
                             responseType = "continuous",
                             txVec = txVec,
                             guess = NULL,
                             suppress = TRUE)

is(obj)
coef(obj)
cvInfo(obj)
DTRstep(obj)
estimator(obj)
fitObject(obj)
optimObj(obj)
optTx(obj)
optTx(obj,bmiData)
outcome(obj)
print(obj)
propen(obj)
regimeCoef(obj)
show(obj)
summary(obj)

obj <- DynTxRegime:::.newRWL(moPropen = moPropen,
                             moMain = moMain,
                             data = bmiData,
                             response = y,
                             txName = "A2",
                             regime = regime,
                             lambdas = c(0.1,0.2),
                             cvFolds = 4L,
                             kernel = "linear",
                             kparam = NULL,
                             responseType = "continuous",
                             txVec = txVec,
                             guess = NULL,
                             suppress = TRUE)

is(obj)
coef(obj)
cvInfo(obj)
DTRstep(obj)
estimator(obj)
fitObject(obj)
optimObj(obj)
optTx(obj)
optTx(obj,bmiData)
outcome(obj)
print(obj)
propen(obj)
regimeCoef(obj)
show(obj)
summary(obj)


obj <- DynTxRegime:::.newRWL(moPropen = moPropen,
                             moMain = moMain,
                             data = bmiData,
                             response = y,
                             txName = "A2",
                             regime = regime,
                             lambdas = c(0.1,0.2),
                             cvFolds = 4L,
                             kernel = "radial",
                             kparam = c(1,2),
                             responseType = "continuous",
                             txVec = txVec,
                             guess = NULL,
                             suppress = TRUE)

is(obj)
coef(obj)
cvInfo(obj)
DTRstep(obj)
estimator(obj)
fitObject(obj)
optimObj(obj)
optTx(obj)
optTx(obj,bmiData)
outcome(obj)
print(obj)
propen(obj)
regimeCoef(obj)
show(obj)
summary(obj)

obj <- DynTxRegime:::.newRWL(moPropen = moPropen,
                             moMain = moMain,
                             data = bmiData,
                             response = y,
                             txName = "A2",
                             regime = regime,
                             lambdas = 0.1,
                             cvFolds = 4L,
                             kernel = "radial",
                             kparam = c(1,2),
                             responseType = "continuous",
                             txVec = txVec,
                             guess = NULL,
                             suppress = TRUE)

is(obj)
coef(obj)
cvInfo(obj)
DTRstep(obj)
estimator(obj)
fitObject(obj)
optimObj(obj)
optTx(obj)
optTx(obj,bmiData)
outcome(obj)
print(obj)
propen(obj)
regimeCoef(obj)
show(obj)
summary(obj)
}
}

\keyword{internal}

