% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/R_bowl.R
\name{bowl}
\alias{bowl}
\title{Backwards Outcome Weighted Learning.}
\usage{
bowl(
  ...,
  moPropen,
  data,
  reward,
  txName,
  regime,
  response,
  BOWLObj = NULL,
  lambdas = 2,
  cvFolds = 0L,
  kernel = "linear",
  kparam = NULL,
  fSet = NULL,
  surrogate = "hinge",
  verbose = 2L
)
}
\arguments{
\item{...}{Used primarily to require named input. However, inputs for
the optimization methods can be sent through the ellipsis. If surrogate
is hinge, the optimization method is dfoptim::hjk(). For all other 
surrogates, stats::optim() is used.}

\item{moPropen}{An object of class modelObj or modelObjSubset, which 
defines the model and
R methods to be used to obtain parameter estimates and
predictions for the propensity for tx.
See ?moPropen for details.}

\item{data}{A data frame of the covariates and tx histories.}

\item{reward}{The response vector.}

\item{txName}{A character object.
The column header of \emph{data} that corresponds to the tx covariate}

\item{regime}{A formula object or a list of formula objects.
The covariates to be included in the decision function/kernel. 
If a list is provided,
this specifies that there is an underlying subset structure -- fSet must
then be defined. For subsets, the name of each element of the list must 
correspond to the name of a subset. If a regime is to be estimated using
multiple subsets combined, each subset must be included in the name and
separated by a comma (no spaces).}

\item{response}{A numeric vector.
The same as reward above. Allows for naming convention followed in most
DynTxRegime methods.}

\item{BOWLObj}{NULL or \code{\link{BOWL-class}} object returned from 
previous call to bowl(). If NULL, indicates that the function call is 
for the first STEP of the BOWL algorithm (i.e., the final decision point). 
If a \code{\link{BOWL-class}} object, assumed that the object was 
returned by the preceding step of the BOWL algorithm.}

\item{lambdas}{A numeric object or a numeric vector object giving the
penalty tuning parameter(s). If more than 1 is provided,
the set of tuning parameter values to be considered in the
cross-validation algorithm (note that cvFolds must be positive in this case).}

\item{cvFolds}{If cross-validation is to be used to select the tuning
parameters and/or kernel parameters, the number of folds.}

\item{kernel}{A character object.
Must be one of \{'linear', 'poly', 'radial'\}}

\item{kparam}{A numeric object. \cr
If kernel = linear, kparam is ignored. \cr
If kernel = poly, kparam is the degree of the polynomial. \cr
If kernel = radial, kparam is the inverse bandwidth of the
kernel. If a vector of bandwidth parameters is given,
cross-validation will be used to select the parameter
(note that cvFolds must be positive in this case).}

\item{fSet}{A function or NULL defining subset structure. See ?fSet for
details.}

\item{surrogate}{The surrogate 0-1 loss function. Must be one of
\{'logit', 'exp', 'hinge', 'sqhinge', 'huber'\}.}

\item{verbose}{An integer or logical. If 0, no screen prints are generated. If 1,
screen prints are generated with the exception of optimization results
obtained in iterative algorithm. If 2, all screen prints are generated.}
}
\value{
a \code{\link{BOWL-class}} object
}
\description{
Function performs a single step
  of the bowl method. Multiple decision points can be analyzed by
  repeated calls, as is done for qLearn() and optimalClass().
}
\examples{
 
# Load and process data set
data(bmiData)

# define the negative 12 month change in BMI from baseline
y12 <- -100*(bmiData[,6L] - bmiData[,4L])/bmiData[,4L]

# define the negative 4 month change in BMI from baseline
y4 <- -100*(bmiData[,5L] - bmiData[,4L])/bmiData[,4L]

# reward for second stage
rewardSS <- y12 - y4

#### Second-stage regression

# Constant propensity model
moPropen <- buildModelObj(model = ~1,
                          solver.method = 'glm',
                          solver.args = list('family'='binomial'),
                          predict.method = 'predict.glm',
                          predict.args = list(type='response'))

fitSS <- bowl(moPropen = moPropen,
              data = bmiData, reward = rewardSS,  txName = 'A2', 
              regime = ~ parentBMI + month4BMI)

##Available methods

  # Coefficients of the propensity score regression
  coef(fitSS)

  # Description of method used to obtain object
  DTRstep(fitSS)

  # Estimated value of the optimal treatment regime for training set
  estimator(fitSS)

  # Value object returned by propensity score regression method
  fitObject(fitSS)

  # Summary of optimization routine
  optimObj(fitSS)

  # Estimated optimal treatment for training data
  optTx(fitSS)

  # Estimated optimal treatment for new data
  optTx(fitSS, bmiData)

  # Plots if defined by propensity regression method
  dev.new()
  par(mfrow = c(2,4))

  plot(fitSS)
  plot(fitSS, suppress = TRUE)

  # Value object returned by propensity score regression method
  propen(fitSS)

  # Parameter estimates for decision function
  regimeCoef(fitSS)

  # Show main results of method
  show(fitSS)

  # Show summary results of method
  summary(fitSS)
 
#### First-stage regression

# Constant propensity model
fitFS <- bowl(moPropen = moPropen,
              data = bmiData, reward = y4,  txName = 'A1', 
              regime = ~ gender + parentBMI,
              BOWLObj = fitSS, lambdas = c(0.5, 1.0), cvFolds = 4L)

##Available methods for fitFS are as shown above for fitSS

  # Results of the cross-validation
  cvInfo(fitFS)

}
\references{
Yingqi Zhao, Donglin Zeng, Eric B. Laber, Michael R. Kosorok
   (2015)
   New statistical learning methods for estimating optimal dynamic
   treatment regimes.
   Journal of the American Statistical Association,
   110:510, 583--598.
}
\seealso{
Other statistical methods: 
\code{\link{earl}()},
\code{\link{iqLearn}},
\code{\link{optimalClass}()},
\code{\link{optimalSeq}()},
\code{\link{owl}()},
\code{\link{qLearn}()},
\code{\link{rwl}()}

Other weighted learning methods: 
\code{\link{earl}()},
\code{\link{owl}()},
\code{\link{rwl}()}

Other multiple decision point methods: 
\code{\link{iqLearn}},
\code{\link{optimalClass}()},
\code{\link{optimalSeq}()},
\code{\link{qLearn}()}
}
\concept{multiple decision point methods}
\concept{statistical methods}
\concept{weighted learning methods}
