% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_models.R
\name{run_models}
\alias{run_models}
\title{Run multiple \bold{existing} \code{mod} or \code{dyn} files.}
\usage{
run_models(model, path = "")
}
\arguments{
\item{model}{Object or a  vector of character strings representing the names of the \code{Dynare} model files excluding \code{.mod} or \code{.dyn} file extension}

\item{path}{Object or a character string representing the path to the folder for the \code{Dynare} file. The current working directory is the default \code{path}. Specify the \code{path} only if the \code{Dynare} files live in different path from the current working directory.}
}
\value{
Set of \code{Dynare} (open-source software for DSGE modelling) outputs
}
\description{
Use this function to execute multiple \bold{existing} \code{Dynare} files.
Use \code{run_models(file)}  if the Dynare files live in the current working directory.
Use \code{run_models(file,path)}  if the Dynare files live in the path different from the current working directory.
}
\examples{
library(DynareR)

# Provide the list of the `Dynare` files in a vector
model=c("example1","example2","agtrend","bkk")
\dontrun{

run_models(model)
}
}
\seealso{
write_mod write_dynare eng_dynare run_dynare
}
\keyword{documentation}
