% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ebase_eqboxy.R
\name{ebase_eqboxy}
\alias{ebase_eqboxy}
\title{Oxygen saturation}
\usage{
ebase_eqboxy(temp, salt)
}
\arguments{
\item{temp}{numeric for temperature (C)}

\item{salt}{numeric for salinity (PSU)}
}
\value{
oxysat (mmol/m^3)
}
\description{
Oxygen saturation
}
\details{
Function to calculate equilibrium OXYGEN concentration in seawater, from water temparure (C) and salinity (PSU)
}
\examples{
temp <- c(10, 20, 30)
salt <- c(30, 35, 40)
ebase_eqboxy(temp = temp, salt = salt)
}
\references{
Garcia, H., Gordon, L.I., 1992. Oxygen solubility in seawater: Better fitting equations. Limnology and Oceanography 37, 1307-1312. https://doi.org/10.4319/lo.1992.37.6.1307
}
