% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interp_plot.R
\name{interp_plot}
\alias{interp_plot}
\title{Create a diagnostic plot showing interpolated values prior to metabolism estimates}
\usage{
interp_plot(
  dat,
  param = c("DO_obs", "DO_sat", "Z", "Temp", "Sal", "PAR", "WSpd", "sc"),
  Z,
  interval,
  ndays = 1
)
}
\arguments{
\item{dat}{input data frame}

\item{param}{character string of the parameter to plot, one of \code{DO_obs}, \code{DO_sat}, \code{Z}, \code{Temp}, \code{Sal}, \code{PAR}, \code{WSpd}, or \code{sc}}

\item{Z}{numeric as single value for water column depth (m) or vector equal in length to number of rows in \code{dat}}

\item{interval}{timestep interval in seconds}

\item{ndays}{numeric for number of days in \code{dat} for optimizing the metabolic equation, see details}
}
\value{
A \code{\link[ggplot2]{ggplot}} object
}
\description{
Create a diagnostic plot showing interpolated values prior to metabolism estimates
}
\details{
Missing values in the input data can also be interpolated prior to estimating metabolism.  This is the default behavior and it is the responsibility of the user to verify that these interpolated values are not wildly inaccurate.  Missing values are linearly interpolated between non-missing values at the time step specified by the value in \code{interval}.  This works well for small gaps, but can easily create inaccurate values at gaps larger than a few hours. The plot from this function can be used to visually assess the interpolated gaps.
}
\examples{
library(dplyr)

# get four days of data
dat <- exdat \%>\% 
  filter(lubridate::month(DateTimeStamp) == 6) \%>\% 
  filter(lubridate::day(DateTimeStamp) \%in\% 1:4)
  
# create missing values
set.seed(222)
dat <- dat \%>\% 
  slice_sample(prop = 0.9) \%>\% 
  arrange(DateTimeStamp)

interp_plot(dat, Z = 1.85, interval = 900, param = 'DO_sat')
}
