% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prior_plot.R
\name{prior_plot}
\alias{prior_plot}
\title{Plot prior distributions for a, R, and b}
\usage{
prior_plot(
  aprior = c(4, 2),
  rprior = c(300, 150),
  bprior = c(0.251, 0.125),
  bmax = 0.502,
  n = 1000
)
}
\arguments{
\item{aprior}{numeric vector of length two indicating the mean and standard deviation for the prior distribution of the \emph{a} parameter, see details}

\item{rprior}{numeric vector of length two indicating the mean and standard deviation for the prior distribution of the \emph{R} parameter, see details}

\item{bprior}{numeric vector of length two indicating the mean and standard deviation for the prior distribution of the \emph{b} parameter, see details}

\item{bmax}{numeric value for the upper limit on the prior distribution for \code{bprior}, set as twice the default value of the mean}

\item{n}{numeric indicating number of random samples to draw from prior distributions}
}
\value{
A \code{\link[ggplot2]{ggplot}} object
}
\description{
Plot prior distributions for a, R, and b
}
\details{
This function produces a plot of the prior distributions that are used in \code{\link{ebase}} for the \emph{a}, \emph{R}, and \emph{b} parameters for the optimization equation for estimating metabolism.  The \code{\link{ebase}} function uses the same default values for the arguments for \code{aprior}, \code{rprior}, and \code{bprior} as required for this function.  If the default values are changed for \code{\link{ebase}}, this function can be used to assess how changing characteristics of the prior distributions could influence the resulting parameter estimates and their posterior distributions (e.g., as shown with \code{\link{credible_plot}}.

All parameters follow a normal Gaussian distribution for the priors with the means and standard deviations defined by the arguments. All distributions are truncated to include only values greater than zero as required by the core metabolism equation. The upper limit for \emph{b} is also set as twice the default value of the mean in the \code{bprior} argument. Truncated normal distributions are obtained using the \code{\link[truncnorm]{rtruncnorm}} function with the number of random samples defined by the \code{n} argument.

The density curves for each parameter are normalized such that the peak values are always equal to 1.
}
\examples{
# default plot
prior_plot()

# changing the mean and standard deviation for the b parameter
prior_plot(bprior = c(0.2, 0.05))
}
