% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimNonNormalDist.R
\name{SimMixDist}
\alias{SimMixDist}
\title{SimMixDist function}
\usage{
SimMixDist(nInv, mean, std, p1, p2)
}
\arguments{
\item{nInv}{is a number of samples the function will generate.}

\item{mean}{is a mean of a normal distribution part of mixture distribution.}

\item{std}{is a standard deviation of a normal distribution part of mixture distribution.}

\item{p1}{is a ratio of a normal distribution within a mixture distribution.}

\item{p2}{is a ratio of a Cauchy distribution within a mixture distribution.}
}
\value{
This function returns a list of samples \code{V} generated by a mixture distribution.
}
\description{
SimMixDist is a support function for generating samples from mixture distribution.
The main purpose of this function is to generate samples from non-normal distribution.
}
\examples{
# Generate simulation data with 100 samples with a mixture distribution
# The distribution consist of the following distributions:
# 1) 10\% of uniform distribution range [-400,400];
# 2) 50\% of normal distribution with mean = 40 and std =8; and
# 3) 40\% of Cauchy distribution with location= 45 and scale = 2.

V<-SimMixDist(nInv=100,mean=40,std=8,p1=0.1,p2=0.5)


}
