% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EEAaq_summary.R
\name{EEAaq_summary}
\alias{EEAaq_summary}
\title{Generate an \code{EEAaq_df} data summary}
\usage{
EEAaq_summary(data = NULL, verbose = TRUE)
}
\arguments{
\item{data}{an \code{EEAaq_df} or \code{EEAaq_df_sfc} class object, which is the output of the \code{\link{EEAaq_get_data}} function.}

\item{verbose}{logic value (T or F). If \code{TRUE} (the default) messages about the function progress are printed.
If \code{FALSE} no message is printed.}
}
\value{
The function \code{EEAaq_summary} computes and return a list of summary statistics of the dataset given in
\code{data}. In particular the elements of the list are:
\itemize{
\item{\code{Summary} global missing count, missing rate, negative count, minimum, maximum,
mean and standard deviation, organized by pollutant.}
\item{\code{Summary_byStat} list of data frames, one for each different station, containing
the descriptive statistics (missing count, missing rate, negative count, minimum, maximum,
mean and standard deviation), organized by station.}
\item{\code{gap_length} one data frame for each pollutant, containing the gap length organized by station.}
\item{\code{Corr_Matrix} if \code{data} contains more than one pollutant, the correlation matrix between
pollutans is provided, organised by station.}
}
}
\description{
This function, applied to an \code{EEAaq_df} or \code{EEAaq_df_sfc} class object, produces a list of data frames,
containing relevant information about the data, such as descriptive statistics, missing values statistics,
gap length and correlation.
}
\examples{
\donttest{
data <- EEAaq_get_data(zone_name = "Milano", NUTS_level = "LAU",
  pollutant = "PM10", from = 2023, to = 2023, ID = FALSE, verbose = TRUE)
EEAaq_summary(data)
}
}
