% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/fold.R
\name{fold}
\alias{fold}
\alias{fold.matrix}
\alias{fold.numeric}
\title{Fold EEM matrix into a list}
\usage{
fold(EEM_uf)

\method{fold}{matrix}(EEM_uf)

\method{fold}{numeric}(EEM_uf)
}
\arguments{
\item{EEM_uf}{Unfolded EEM matrix where columns are wavelength condition and rows are samples.
It should have corresponding column names (formatted as EX###EM###) and row names.}
}
\value{
EEM a list containing EEM/EEM data
}
\description{
Fold EEM matrix into a list
}
\examples{
data(applejuice)
applejuice_uf <- unfold(applejuice) # unfold list into matrix
applejuice_uf_norm <- normalize(applejuice_uf) # normalize matrix
drawEEM(fold(applejuice_uf_norm), 1) # visualize normalized EEM
}

