% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.CD}
\alias{plot.CD}
\title{Plot Comparison Data for Factor Analysis}
\usage{
\method{plot}{CD}(x, ...)
}
\arguments{
\item{x}{An object of class \code{CD}, representing the results to be plotted.}

\item{...}{Additional arguments to be passed to the plotting function.}
}
\value{
None. This function is used for side effects (plotting).
}
\description{
This function generates a Comparison Data plot to visualize the Root Mean Square Error (RMSE) of
eigenvalues for various numbers of factors. This plot helps in evaluating the fit of different
factor models and identifying the optimal number of factors based on RMSE values.
}
\examples{
library(EFAfactors)
set.seed(123)

##Take the data.bfi dataset as an example.
data(data.bfi)

response <- as.matrix(data.bfi[, 1:25]) ## loading data
response <- na.omit(response) ## Remove samples with NA/missing values

## Transform the scores of reverse-scored items to normal scoring
response[, c(1, 9, 10, 11, 12, 22, 25)] <- 6 - response[, c(1, 9, 10, 11, 12, 22, 25)] + 1

\donttest{
CD.obj <- CD(response)

## CD plot
plot(CD.obj)

}

}
\seealso{
\link[EFAfactors]{CD}
}
