% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plots}
\alias{plots}
\alias{plot.bootEGA}
\alias{plot.CFA}
\alias{plot.dynEGA}
\alias{plot.dynEGA.Groups}
\alias{plot.dynEGA.Individuals}
\alias{plot.EGA}
\alias{plot.NetLoads}
\title{S3Methods for Plotting}
\usage{
\method{plot}{bootEGA}(x, vsize = 6, ...)

\method{plot}{CFA}(x, layout = "spring", vsize = 6, ...)

\method{plot}{dynEGA}(x, title = "", vsize = 6,  ...)

\method{plot}{dynEGA.Groups}(x, ncol, nrow, title = "", vsize = 6,  ...)

\method{plot}{dynEGA.Individuals}(x, title = "", vsize = 6,  id = NULL, ...)

\method{plot}{EGA}(x, title = "", vsize = 6,  ...)

\method{plot}{NetLoads}(x, ...)
}
\arguments{
\item{x}{Object from \code{EGAnet} package}

\item{vsize}{Numeric.
Size of vertices in network plots.
Defaults to \code{6}}

\item{...}{Arguments passed on to

\itemize{

\item{\code{\link[qgraph]{qgraph}}}
{Functions: bootEGA, dynEGA, dynEGA.Groups, dynEGA.Individuals, EGA, and net.loads}

\item{\code{\link[semPlot]{semPaths}}}
{Functions: CFA}

}}

\item{layout}{Character.
Layout of plot (see \code{\link[semPlot]{semPaths}}).
Defaults to "spring"}

\item{ncol}{Numeric.
Number of columns}

\item{nrow}{Numeric.
Number of rows}

\item{title}{Character.
Title of the plot.
Defaults to \code{""}}

\item{id}{Numeric.
An integer or character indicating the ID of the individual to plot}
}
\value{
Plots of \code{EGAnet} object
}
\description{
Plots for \code{EGAnet} objects
}
\author{
Hudson Golino <hfg9s at virginia.edu> and Alexander P. Christensen <alexpaulchristensen@gmail.com>
}
