% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/riEGA.R
\name{riEGA}
\alias{riEGA}
\title{Random-Intercept \code{\link[EGAnet]{EGA}}}
\usage{
riEGA(
  data,
  n = NULL,
  uni.method = c("expand", "LE"),
  corr = c("cor_auto", "pearson", "spearman"),
  model = c("glasso", "TMFG"),
  model.args = list(),
  algorithm = c("walktrap", "louvain"),
  algorithm.args = list(),
  plot.EGA = TRUE,
  plot.type = c("GGally", "qgraph"),
  plot.args = list(),
  estimator = c("auto", "WLSMV", "MLR"),
  lavaan.args = list(),
  verbose = TRUE
)
}
\arguments{
\item{data}{Matrix or data frame.
Variables (down columns) or correlation matrix.
If the input is a correlation matrix,
then argument \code{n} (number of cases) is \strong{required}.
Variables \strong{MUST} be unrecoded -- reversed items should
\strong{remain} reversed}

\item{n}{Integer.
Sample size if \code{data} provided is a correlation matrix}

\item{uni.method}{Character.
What unidimensionality method should be used? 
Defaults to \code{"LE"}.
Current options are:

\itemize{

\item{\strong{\code{expand}}}
{Expands the correlation matrix with four variables correlated .50.
If number of dimension returns 2 or less in check, then the data 
are unidimensional; otherwise, regular EGA with no matrix
expansion is used. This is the method used in the Golino et al. (2020)
\emph{Psychological Methods} simulation.}

\item{\strong{\code{LE}}}
{Applies the leading eigenvalue algorithm (\code{\link[igraph]{cluster_leading_eigen}})
on the empirical correlation matrix. If the number of dimensions is 1,
then the leading eigenvalue solution is used; otherwise, regular EGA
is used. This is the final method used in the Christensen, Garrido,
and Golino (2021) simulation.}

}}

\item{corr}{Type of correlation matrix to compute. The default uses \code{\link[qgraph]{cor_auto}}.
Current options are:

\itemize{

\item{\strong{\code{cor_auto}}}
{Computes the correlation matrix using the \code{\link[qgraph]{cor_auto}} function from
\code{\link[qgraph]{qgraph}}}.

\item{\strong{\code{pearson}}}
{Computes Pearson's correlation coefficient using the pairwise complete observations via
the \code{\link[stats]{cor}}} function.

\item{\strong{\code{spearman}}}
{Computes Spearman's correlation coefficient using the pairwise complete observations via
the \code{\link[stats]{cor}}} function.
}}

\item{model}{Character.
A string indicating the method to use.
Defaults to \code{"glasso"}.
Current options are:

\itemize{

\item{\strong{\code{glasso}}}
{Estimates the Gaussian graphical model using graphical LASSO with
extended Bayesian information criterion to select optimal regularization parameter}

\item{\strong{\code{TMFG}}}
{Estimates a Triangulated Maximally Filtered Graph}

}}

\item{model.args}{List.
A list of additional arguments for \code{\link[EGAnet]{EBICglasso.qgraph}}
or \code{\link[NetworkToolbox]{TMFG}}}

\item{algorithm}{A string indicating the algorithm to use or a function from \code{\link{igraph}}
Defaults to \code{"walktrap"}.
Current options are:

\itemize{

\item{\strong{\code{walktrap}}}
{Computes the Walktrap algorithm using \code{\link[igraph]{cluster_walktrap}}}

\item{\strong{\code{louvain}}}
{Computes the Louvain algorithm using \code{\link[igraph]{cluster_louvain}}}

}}

\item{algorithm.args}{List.
A list of additional arguments for \code{\link[igraph]{cluster_walktrap}}, \code{\link[igraph]{cluster_louvain}},
or some other community detection algorithm function (see examples)}

\item{plot.EGA}{Boolean.
If \code{TRUE}, returns a plot of the network and its estimated dimensions.
Defaults to \code{TRUE}}

\item{plot.type}{Character.
Plot system to use.
Current options are \code{\link[qgraph]{qgraph}} and \code{\link{GGally}}.
Defaults to \code{"GGally"}}

\item{plot.args}{List.
A list of additional arguments for the network plot.
For \code{plot.type = "qgraph"}:

\itemize{

\item{\strong{\code{vsize}}}
{Size of the nodes. Defaults to 6.}

}
For \code{plot.type = "GGally"} (see \code{\link[GGally]{ggnet2}} for
full list of arguments):

\itemize{

\item{\strong{\code{vsize}}}
{Size of the nodes. Defaults to 6.}

\item{\strong{\code{label.size}}}
{Size of the labels. Defaults to 5.}

\item{\strong{\code{alpha}}}
{The level of transparency of the nodes, which might be a single value or a vector of values. Defaults to 0.7.}

\item{\strong{\code{edge.alpha}}}
{The level of transparency of the edges, which might be a single value or a vector of values. Defaults to 0.4.}

 \item{\strong{\code{legend.names}}}
{A vector with names for each dimension}

\item{\strong{\code{color.palette}}}
{The color palette for the nodes. For custom colors,
enter HEX codes for each dimension in a vector.
See \code{\link[EGAnet]{color_palette_EGA}} for
more details and examples}

}}

\item{estimator}{Character.
Estimator to use for random-intercept model (see \href{https://lavaan.ugent.be/tutorial/est.html}{Estimators}
for more details).
Defaults to \code{"auto"}, which selects \code{"MLR"} for continuous data and
\code{"WLSMV"} for mixed and categorical data.
Data are considered continuous data if they have 6 or
more categories (see Rhemtulla, Brosseau-Liard, & Savalei, 2012)}

\item{lavaan.args}{List.
If \code{reduce.method = "latent"}, then \code{\link{lavaan}}'s \code{\link[lavaan]{cfa}}
function will be used to create latent variables to reduce variables.
Arguments should be input as a list. Some example arguments 
(see \code{\link[lavaan]{lavOptions} for full details})}

\item{verbose}{Boolean.
Should network estimation parameters be printed?
Defaults to \code{TRUE}.
Set to \code{FALSE} for no print out}
}
\value{
Returns a list containing:

\item{EGA}{Results from \code{\link[EGAnet]{EGA}}}

\item{RI}{A list containing information about the random-intercept
model (if the model converged):

\itemize{

\item{fit}
{The fit object for the random-intercept model using \code{\link[lavaan]{cfa}}}

\item{lavaan.args}
{The arguments used in \code{\link[lavaan]{cfa}}}

\item{loadings}
{Standardized loadings from the random-intercept model}

\item{correlation}
{Residual correlations after accounting for the random-intercept model}

}



}
}
\description{
Estimates the number of substantive dimensions after controlling for wording effects. 
EGA is applied to a residual correlation matrix after subtracting and random intercept
factor with equal unstandardized loadings from all the regular and unrecoded
reversed items in the database
}
\examples{
# Obtain example data
data <- optimism

\dontrun{
# riEGA example
opt.res <- riEGA(data = optimism)
}

}
\references{
# Selection of CFA Estimator \cr
Rhemtulla, M., Brosseau-Liard, P. E., & Savalei, V. (2012).
When can categorical variables be treated as continuous? A comparison of robust continuous and categorical SEM estimation methods under suboptimal conditions.
\emph{Psychological Methods}, \emph{17}, 354-373.
}
\author{
Alejandro Garcia-Pardina <alejandrogp97@gmail.com>,
Francisco J. Abad <fjose.abad@uam.es>,
Alexander P. Christensen <alexpaulchristensen@gmail.com>,
Hudson Golino <hfg9s at virginia.edu>,
Luis Eduardo Garrido <luisgarrido@pucmm.edu.do>, and
Robert Moulder <rgm4fd@virginia.edu>
}
