% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/community.unidimensional.R
\name{community.unidimensional}
\alias{community.unidimensional}
\title{Approaches to Detect Unidimensional Communities}
\usage{
community.unidimensional(
  data,
  n = NULL,
  corr = c("auto", "cor_auto", "pearson", "spearman"),
  na.data = c("pairwise", "listwise"),
  model = c("BGGM", "glasso", "TMFG"),
  uni.method = c("expand", "LE", "louvain"),
  verbose = FALSE,
  ...
)
}
\arguments{
\item{data}{Matrix or data frame.
Should consist only of variables that are desired to be in analysis}

\item{n}{Numeric (length = 1).
Sample size if \code{data} provided is a correlation matrix}

\item{corr}{Character (length = 1).
Method to compute correlations.
Defaults to \code{"auto"}.
Available options:

\itemize{

\item \code{"auto"} --- Automatically computes appropriate correlations for
the data using Pearson's for continuous, polychoric for ordinal,
tetrachoric for binary, and polyserial/biserial for ordinal/binary with
continuous. To change the number of categories that are considered
ordinal, use \code{ordinal.categories}
(see \code{\link[EGAnet]{polychoric.matrix}} for more details)

\item \code{"cor_auto"} --- Uses \code{\link[qgraph]{cor_auto}} to compute correlations. 
Arguments can be passed along to the function

\item \code{"pearson"} --- Pearson's correlation is computed for all 
variables regardless of categories

\item \code{"spearman"} --- Spearman's rank-order correlation is computed 
for all variables regardless of categories

}

For other similarity measures, compute them first and input them
into \code{data} with the sample size (\code{n})}

\item{na.data}{Character (length = 1).
How should missing data be handled?
Defaults to \code{"pairwise"}.
Available options:

\itemize{

\item \code{"pairwise"} --- Computes correlation for all available cases between
two variables

\item \code{"listwise"} --- Computes correlation for all complete cases in the dataset

}}

\item{model}{Character (length = 1).
Defaults to \code{"glasso"}.
Available options:

\itemize{

\item \code{"BGGM"} --- Computes the Bayesian Gaussian Graphical Model.
Set argument \code{ordinal.categories} to determine
levels allowed for a variable to be considered ordinal.
See \code{?BGGM::estimate} for more details

\item \code{"glasso"} --- Computes the GLASSO with EBIC model selection.
See \code{\link[EGAnet]{EBICglasso.qgraph}} for more details

\item \code{"TMFG"} --- Computes the TMFG method.
See \code{\link[EGAnet]{TMFG}} for more details

}}

\item{uni.method}{Character (length = 1).
What unidimensionality method should be used? 
Defaults to \code{"louvain"}.
Available options:

\itemize{

\item \code{"expand"} --- Expands the correlation matrix with four variables correlated 0.50.
If number of dimension returns 2 or less in check, then the data 
are unidimensional; otherwise, regular EGA with no matrix
expansion is used. This method was used in the Golino et al.'s (2020)
\emph{Psychological Methods} simulation

\item \code{"LE"} --- Applies the Leading Eigenvector algorithm
(\code{\link[igraph]{cluster_leading_eigen}})
on the empirical correlation matrix. If the number of dimensions is 1,
then the Leading Eigenvector solution is used; otherwise, regular EGA
is used. This method was used in the Christensen et al.'s (2023) 
\emph{Behavior Research Methods} simulation

\item \code{"louvain"} --- Applies the Louvain algorithm (\code{\link[igraph]{cluster_louvain}})
on the empirical correlation matrix. If the number of dimensions is 1, 
then the Louvain solution is used; otherwise, regular EGA is used. 
This method was validated Christensen's (2022) \emph{PsyArXiv} simulation.
Consensus clustering can be used by specifying either
\code{"consensus.method"} or \code{"consensus.iter"}

}}

\item{verbose}{Boolean.
Whether messages and (insignificant) warnings should be output.
Defaults to \code{FALSE} (silent calls).
Set to \code{TRUE} to see all messages and warnings for every function call}

\item{...}{Additional arguments to be passed on to
\code{\link[EGAnet]{auto.correlate}}, 
\code{\link[EGAnet]{network.estimation}},
\code{\link[EGAnet]{community.consensus}}, and 
\code{\link[EGAnet]{community.detection}}}
}
\value{
Returns the memberships of the community detection algorithm.
The memberships will output \emph{regardless} of whether the
network is unidimensional
}
\description{
A function to apply several approaches to detect a unidimensional community in 
networks. There have many different approaches recently such as expanding
the correlation matrix to have orthogonal correlations (\code{"expand"}),
applying the Leading Eigenvalue community detection algorithm
\code{\link[igraph]{cluster_leading_eigen}} to the correlation matrix
(\code{"LE"}), and applying the Louvain community detection algorithm
\code{\link[igraph]{cluster_louvain}} to the correlation matrix (\code{"louvain"}).
Not necessarily intended for individual use -- it's better to use \code{\link[EGAnet]{EGA}}
}
\examples{
# Load data
wmt <- wmt2[,7:24]

# Louvain with Consensus Clustering (default)
community.unidimensional(wmt)

# Leading Eigenvector
community.unidimensional(wmt, uni.method = "LE")

# Expand
community.unidimensional(wmt, uni.method = "expand")

}
\references{
\strong{Expand approach} \cr
Golino, H., Shi, D., Christensen, A. P., Garrido, L. E., Nieto, M. D., Sadana, R., Thiyagarajan, J. A., & Martinez-Molina, A. (2020).
Investigating the performance of exploratory graph analysis and traditional techniques to identify the number of latent factors:
A simulation and tutorial.
\emph{Psychological Methods}, \emph{25}, 292-320. 

\strong{Leading Eigenvector approach} \cr
Christensen, A. P., Garrido, L. E., Guerra-Pena, K., & Golino, H. (2023).
Comparing community detection algorithms in psychometric networks: A Monte Carlo simulation.
\emph{Behavior Research Methods}.

\strong{Louvain approach} \cr
Christensen, A. P. (2023).
Unidimensional community detection: A Monte Carlo simulation, grid search, and comparison.
\emph{PsyArXiv}.
}
\author{
Hudson Golino <hfg9s at virginia.edu> and Alexander P. Christensen <alexpaulchristensen@gmail.com>
}
