% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotMonthTrend.R
\name{plotMonthTrend}
\alias{plotMonthTrend}
\title{Plot monthly trend result from runPairs}
\usage{
plotMonthTrend(pairResults, yMax = NA, arrowFactor = 0.75, flux = TRUE,
  printTitle = TRUE, concLab = 1, monthLab = 1)
}
\arguments{
\item{pairResults}{results from \code{runPairs}.}

\item{yMax}{numeric. Upper limit for plot. Default is \code{NA},
which will use the maximum of the data.}

\item{arrowFactor}{numeric. Scaling factor for the size of the arrows.
The arrows are automatically scaled to the overall trend. This scaling 
factor helps adjust how big/small they are.}

\item{flux}{logical. \code{TRUE} is flux, \code{FALSE} is concentration.
Default is \code{TRUE}.}

\item{printTitle}{logical variable if TRUE title is printed, if FALSE title is not printed (this is best for a multi-plot figure)}

\item{concLab}{object of concUnit class, or numeric represented the short code, 
or character representing the descriptive name. By default, this argument sets
concentration labels to use either Concentration or Conc (for tiny plots). Units
are taken from the eList$INFO$param.units. To use any other words than
"Concentration" see \code{vignette(topic = "units", package = "EGRET")}.}

\item{monthLab}{object of monthLabel class, or numeric represented the short code, 
or character representing the descriptive name.}
}
\value{
Base R plot of monthly trends
}
\description{
Plot monthly trend result from runPairs. The change in concentration
or flux is calculated from the \code{runPairs} function. This plotting
function shows an arrow for each month. If the trend from year1 to year2 
was increasing, the arrow is red and pointing up. If the trend was decreasing,
the arrow is black and pointing down.
}
\details{
The flux values for each month are flow normalized monthly watershed yields 
expressed as kg/month/km^2.  The concentrations are the mean flow normalized
concentration, expressed in whatever concentration units the raw data are
expressed as (typically mg/L).
}
\examples{

eList <- Choptank_eList
year1 <- 1985
year2 <- 2010

\donttest{

pairOut_1 <- runPairs(eList, year1, year2, windowSide = 0)

plotMonthTrend(pairOut_1)
plotMonthTrend(pairOut_1, flux = FALSE)

eList <- setPA(eList, paStart = 12, paLong = 3)
pairOut_2 <- runPairs(eList, year1, year2, windowSide = 0)

plotMonthTrend(pairOut_2)

eList <- setPA(eList, paStart = 1, paLong = 12)
pairOut_3 <- runPairs(eList, year1, year2, windowSide = 0)

plotMonthTrend(pairOut_3)

}
 
}
