% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictionIntervals.R
\name{makeMonthPI}
\alias{makeMonthPI}
\title{Make Monthly Prediction Intervals}
\usage{
makeMonthPI(dailyBootOut, eList, fluxUnit = 3)
}
\arguments{
\item{dailyBootOut}{data frame returned from \code{\link{genDailyBoot}}}

\item{eList}{named list with at least the Daily, Sample, and INFO 
dataframes. Created from the EGRET package, after running \code{\link[EGRET]{modelEstimation}}.}

\item{fluxUnit}{number representing entry in pre-defined fluxUnit class array. 
\code{\link[EGRET]{printFluxUnitCheatSheet}}}
}
\value{
a list of 2 data frames, one for average concentration, in mg/L
and one for flux (unit depends on fluxUnit argument)
In each data frame the first column is monthSeq that corresponds to the months
in the "MonthSeq" column in the eList$Daily data frame. The remaining columns are
quantiles of the flux or concentration (depending on the data frame).
}
\description{
Month statistics using WRTDSKalman bootstrapping approach.  The input to this
function is the dailyBootOut matrix which contains nReplicate sets of 
daily flux values for the period of interest.
The results are in the form of quantiles of concentration and of flux 
for each of these months.
}
\examples{
eList <- EGRET::Choptank_eList
# This example is only based on 4 iterations
# Actual prediction intervals should be calculated on
# a much larger number of iterations (several hundred). 
dailyBoot <- Choptank_dailyBootOut
monthPcts <- makeMonthPI(dailyBoot, eList)
head(monthPcts[["flux"]])
head(monthPcts[["conc"]])

}
