% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fore_p.R
\name{fore_p}
\alias{fore_p}
\title{Simulation plot of enzyme kinetics model}
\usage{
fore_p(method = TRUE, CL = TRUE, time, species, enz, subs, MM, catal,
  nrepeat = 100, ti = 1)
}
\arguments{
\item{method}{method selection: T=TQ model, F=SQ model(default = T)}

\item{CL}{Adding empircal 95\% confidence interval (default = T)}

\item{time}{observed time interval}

\item{species}{observed trajectory of product}

\item{enz}{enzyme concentration}

\item{subs}{substrate concentration}

\item{MM}{true value of MM constant}

\item{catal}{initial value of catalytic constant}

\item{nrepeat}{total number of simulation (default=100)}

\item{ti}{tme interval for descreted simulatin result (default =1)}
}
\value{
This functio has no returned object.
}
\description{
The function depicts the overlayed two plots; one is observed data,
the other is simulation result using fitted MM constant and catalytic constant.
}
\details{
Basically this function draws overlayed picture: The one is trajectory
of given data of products for enzyme kinetics model. The other is trajectory of
products from simulation result of Gillespie algorithm with estimated two
constants, Michaelis-Menten constant and catalytic constant.
CL option controls the plot that depicts the observed data and
mean of simulated series only or adding 95% empirical
confidence interval with 10 samples of simulated trajectory.
}
\examples{
data("Chymo_low")
time1=Chymo_low[,1]
species1=Chymo_low[,2]
fore_p(method=TRUE, CL=TRUE, time=time1,species=species1,enz=4.4e+7, subs=4.4e+7
       ,MM=4.4e+8, catal=.051)
}
