% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lambda.R
\name{lambda.find.gee}
\alias{lambda.find.gee}
\title{Calculate the tuning parameters involved in ELCIC under GEE}
\usage{
lambda.find.gee(x, y, id, beta, r, dist, rho, phi, corstr)
}
\arguments{
\item{x}{A matrix containing covariates. The first column should be all ones corresponding to the intercept.}

\item{y}{A vector containing outcomes.}

\item{id}{A vector indicating subject id.}

\item{beta}{A plug-in estimator solved by an external estimation procedure, such as GEE.}

\item{r}{A vector indicating the observation of outcomes: 1 for observed records, and 0 for unobserved records. The default setup is that all data are observed. See more in details section.}

\item{dist}{A specified distribution. It can be "gaussian", "poisson",and "binomial".}

\item{rho}{A correlation coefficients obtained from an external estimation procedure, such as GEE.}

\item{phi}{An over-dispersion parameter obtained from an external estimation procedure, such as GEE.}

\item{corstr}{A candidate correlation structure. It can be "independence","exchangeable", and "ar1".}
}
\value{
Tuning parameter values.
}
\description{
This function provides an efficient algorithm to calculate the tuning parameters involved in ELCIC under GEE.
}
\details{
If the element in argument "r" equals zero, the corresponding rows of "x" and "y" should be all zeros.
}
\examples{
## tests
# load data
data(geesimdata)
x<-geesimdata$x
y<-geesimdata$y
id<-geesimdata$id
corstr<-"exchangeable"
dist<-"poisson"
# obtain the estimates
library(geepack)
fit<-geeglm(y~x-1,data=geesimdata,family =dist,id=id,corstr = corstr)
beta<-fit$coefficients
rho<-unlist(summary(fit)$corr[1])
phi<-unlist(summary(fit)$dispersion[1])
r=rep(1,nrow(x))
lambda<-lambda.find.gee(x,y,id,beta,r,dist,rho,phi,corstr)
lambda

}
