% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ELISAtools_IO.R
\name{read.annotations}
\alias{read.annotations}
\title{Read the annotations of plates}
\usage{
read.annotations(
  annotation,
  std.conc,
  dir.annotation,
  dir.stdConc,
  num.plate = 1
)
}
\arguments{
\item{annotation}{characters to specify the path and name of the annotation file}

\item{std.conc}{characters to specify the standard concentration file.}

\item{dir.annotation}{characters specifying the file to the annotatoin file.}

\item{dir.stdConc}{characters specifying the path to the annotatoin file.}

\item{num.plate}{numeric indicating the number of plates in the annotation
files.}
}
\value{
a list of annotations for elisa plates.
}
\description{
Parse annotations for multiple ELISA plates from
  	files, one annotation file and one standard concentration file,
	and output the annotations for standard and unknown
	separately.
}
\details{
The annotation file may contain annotations for more than
	one plate. Each plate is marked by "Plate: plate 1..." and 
	"~End". This function parses each section in both annotation
	file and standard concentration file. Then passes the section
	on to do the parsing.
	For each section,we expect
	the following format\cr
\tabular{llllllll}{
   \tab	1\tab	2\tab		3\tab		4\tab 			...\cr	
  C\tab	s1\tab	s1\tab		sample1\tab		sample1\tab	...\cr
  D\tab	s2\tab	s2\tab		sample2\tab		sample\tab  ...\cr	
...\tab	...\tab	...\tab		...\tab		...\tab		...\cr
}
}
\examples{
#get example annotation file path from the system folder
ann<-system.file("extdata", "annote.txt", package="ELISAtools")
std.conc<-system.file("extdata", "stdConc.txt", package="ELISAtools")

#read them in and there are 2 plates.
read.annotations(annotation=ann,  std.conc=std.conc, num.plate=2)
}
