% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eml_validate.R
\name{eml_validate}
\alias{eml_validate}
\title{eml_validate}
\usage{
eml_validate(eml, encoding = character(), ...)
}
\arguments{
\item{eml}{an eml class object, file, or xml document}

\item{encoding}{optional, if eml is a file path / an eml and has special characters, one can
gives the encoding used by xmlParse.}

\item{...}{additional arguments to eml_write, such as namespaces}
}
\value{
Whether the document is valid (logical)
}
\description{
eml_validate processes an EML document using the XSD schema for the
appropriate version of EML and determines if the document is schema-valid
as defined by the XSD specification
}
\examples{
\donttest{

 f <- system.file("xsd/test", "eml.xml", package = "EML")

 ## validate given a file name, without needing to parse first
 eml_validate(f)

## Validate given an "eml" object
eml <- read_eml(f)
eml_validate(eml)

## Can validate fragments as well, though may need the relevant namespace
dataset <- new("dataset", title = "incomplete, invalid EML")
eml_validate(dataset, namespaces = c(ds = "eml://ecoinformatics.org/dataset-2.1.1"), ns = "ds")

}

}

