% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny_attributes.R
\name{shiny_attributes}
\alias{shiny_attributes}
\title{Create/Edit EML attributes}
\usage{
shiny_attributes(data = NULL, attributes = NULL)
}
\arguments{
\item{data}{(data.frame) the data.frame of data that needs an attribute table}

\item{attributes}{(data.frame) an existing attributes table}
}
\description{
Create/edit EML attributes, custom units, and factors in a shiny environment.
}
\details{
Attributes can be created from scratch using \code{shiny_attributes()}.
Or an existing attribute table can be edited using \code{shiny_attributes(NULL, attributes)}.
Or new attributes can be created from a data table using \code{shiny_attributes(data, NULL)}.
If attributes are created from a data table, fields such as `attributeName` and `numberType` will be automatically
completed based on the attributes within the data table.
If both existing attributes and data table are entered (i.e. \code{shiny_attributes(data, attributes)}),
any automatically generated fields based attributes within the data table **will not** override any non-empty fields in the
entered attributes
}
\examples{
\dontrun{
# from scratch
out <- shiny_attributes(NULL, NULL)

# from data
data <- iris
out <- shiny_attributes(data, NULL)

# from exisiting attributes
file <- system.file("tests", emld::eml_version(),
  "eml-datasetWithAttributelevelMethods.xml",
  package = "emld"
)
eml <- read_eml(file)
x <- eml$dataset$dataTable$attributeList
df <- get_attributes(x, eml)
out <- shiny_attributes(NULL, df$attributes)

# from attributes and data
out <- shiny_attributes(data, df$attributes)
}
}
