% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/get.l.R
\name{get.l}
\alias{get.l}
\title{Generate a vector of weight transformation values from l_min to l_max.}
\usage{
get.l(X, n = 10, max = 0.95, min = 0)
}
\arguments{
\item{X}{Numeric matrix with m samples (rows) and n variables (columns).}

\item{n}{Numeric scalar, length of the output vector (by default 10).}

\item{max}{Numeric scalar, fraction of the maximum value (by default 0.95).}

\item{min}{Numeric scalar, minimum value (by default zero).}
}
\value{
Numeric vector of weight transformation values.
}
\description{
This function generates a sequence of weight transformation values that
range from l_min (by default zero) to l_max (by default 95 % of the actual
maximum possible value). It is a wrapper for the function
\code{test.l.max()}.
}
\examples{
## load example data set
data(X, envir = environment())

## infer l-vector
l <- get.l(X = X, n = 5, max = 0.8, min = 0.02)
}
\author{
Michael Dietze, Elisabeth Dietze
}
\references{
Dietze E, Hartmann K, Diekmann B, IJmker J, Lehmkuhl F, Opitz S,
Stauch G, Wuennemann B, Borchers A. 2012. An end-member algorithm for
deciphering modern detrital processes from lake sediments of Lake Donggi
Cona, NE Tibetan Plateau, China. Sedimentary Geology 243-244: 169-180.
}
\seealso{
\code{\link{EMMA}}, \code{\link{test.l.max}}
}
\keyword{EMMA}

