% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EMSC.R
\name{EMSC_model}
\alias{EMSC_model}
\title{Model object for extended multiplicative signal correction (EMSC)}
\usage{
EMSC_model(x, reference = NA, degree = 2, interferent = NULL,
  constituent = NULL, weights = NULL, replicates = NULL,
  rep_corr = 0.9)
}
\arguments{
\item{x}{\code{numeric} vector containing abcissas of spectra to be corrected or matrix to be 
corrected with/without names colnames.}

\item{reference}{\code{numeric} vector containing the reference spectrum.}

\item{degree}{\code{integer} giving the polynomial degree of the baseline; 0 or higher, default = 2.}

\item{interferent}{\code{numeric} vector containing a spectral component to remove.}

\item{constituent}{\code{numeric} vector containing a spectral component to include.}

\item{weights}{\code{numeric} vector of abcissas weights.}

\item{replicates}{optional \code{vector} which identifies replicates. Default = NULL, 
meaning no replicate correctio will be performed.}

\item{rep_corr}{proportion of variance or number of subspace components in replicate space (default = 0.9).}
}
\value{
An EMSC model is returned containing all parameters.
}
\description{
Sets up an EMSC model to be applied to one or more set of spectra.
}
\seealso{
\code{\link{EMSC}} \code{\link{predict.EMSC}} \code{\link{plot.EMSC}}
}
