% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EMTscore_plot.R
\name{Execute_E_M_plot}
\alias{Execute_E_M_plot}
\title{present EMT score result}
\usage{
Execute_E_M_plot(
  cell_annotation_file,
  Methods,
  geneExp,
  M_signature_gene_sets,
  E_signature_gene_sets
)
}
\arguments{
\item{cell_annotation_file}{cell annotation file in data frame, The column name for cell type is "celltype_annotation" and the column name for cell sampleID is "name".}

\item{Methods}{can select nnPCA, ssGSEA, AUCell, SCSE}

\item{geneExp}{gene expression matrix}

\item{M_signature_gene_sets}{M signature gene list in dataframe, we supply example list such as geneList_M, M_signature_for_cancer, M_signature_for_cell}

\item{E_signature_gene_sets}{E signature gene list in dataframe, we supply example list such as geneList_E, E_signature_for_cancer, E_signature_for_cell}
}
\value{
Figure represent EMT scores and cell type
}
\description{
present EMT score result
}
\examples{
library(nsprcomp)
library(ggplot2)
library(dplyr)
library(gridExtra)
library(curl)
Methods = "nnPCA"
data(cell_annotation_file)
url <- "https://zenodo.org/record/15213845/files/geneExp.rda"
destfile <- tempfile(fileext = ".rda")
download.file(url, destfile, mode = "wb")
load(destfile)
data(Panchy_et_al_E_signature)
data(Panchy_et_al_M_signature)


Execute_E_M_plot(cell_annotation_file, 
Methods, 
geneExp, 
M_signature_gene_sets = Panchy_et_al_M_signature, 
E_signature_gene_sets = Panchy_et_al_E_signature
)
}
