% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EMTscore_plot.R
\name{Execute_nnPCA_plot}
\alias{Execute_nnPCA_plot}
\title{present EM score and M dimension score result}
\usage{
Execute_nnPCA_plot(cell_annotation_file, geneExp, gene_lists, fig_title)
}
\arguments{
\item{cell_annotation_file}{A data frame containing cell annotation, with columns `celltype_annotation` and `name`.}

\item{geneExp}{A gene expression matrix.}

\item{gene_lists}{A list of M and E signature gene sets to be used for the nnPCA analysis.}

\item{fig_title}{The title of the figure}
}
\value{
Figure represent two plots: 1): EM score 2): M dimension 1 and dimension 2 scores and cell type
}
\description{
present EM score and M dimension score result
}
\examples{

library(ggpubr)
library(ggplot2)
library(nsprcomp)
library(dplyr)
library(gridExtra)
data(cell_annotation_file)
library(curl)
url <- "https://zenodo.org/record/15213845/files/geneExp.rda"
destfile <- tempfile(fileext = ".rda")
download.file(url, destfile, mode = "wb")
load(destfile)
data(Panchy_et_al_M_signature)
data(Panchy_et_al_E_signature)


gene_lists <- list(Panchy_et_al = list(Panchy_et_al_M_signature, Panchy_et_al_E_signature))

Execute_nnPCA_plot(
cell_annotation_file, 
geneExp, 
gene_lists, 
fig_title = 'RPM'
)  # only for nnPCA method
}
