% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\docType{methods}
\name{varp}
\alias{varp}
\alias{varp,binClstPath-method}
\alias{varp,matrix-method}
\title{Variables' profile plots}
\usage{
varp(obj, ...)

\S4method{varp}{binClstPath}(obj, lims = NULL, ...)

\S4method{varp}{matrix}(obj, lims = NULL, ...)
}
\arguments{
\item{obj}{Either a matrix or a  \link{binClstPath_instance}.}

\item{...}{Parameter \code{lims} is optional.}

\item{lims}{A numeric vector with lower and upper bounds to limit the plot.}
}
\description{
\code{varp} easy plot of input, output and intermediate
  variables of a \link{binClstPath_instance}.
}
\details{
If \code{obj} is a matrix, axes labels are automatically generated from the
\code{colnames()} of the matrix, hence they can be changed as desired.

If \code{obj} is a \link{binClstPath_instance} it plots the values of the
intermediate computations saved in slots mybcp@spn (span times), mybcp@dst
(distances) and mybcp@hdg (local heading directions).
}
\examples{
# -- apply EMbC to the example path --
mybcp <- stbc(expth,info=-1)
# -- plot clustering data points --
varp(mybcp@X)
# -- plot data points' certainties --
varp(mybcp@U)
# -- plot intermediate computations (span-times, distances and headings) in one figure --
varp(mybcp)
\dontrun{
# -- plot only span-times between locations a and b --
plot(seq(a,b),mybcp@spn[a:b],col=4,type='l',xlab='loc',ylab='spanTime (s)')
}
}
