% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enmtools.hypervolume.R
\name{enmtools.hypervolume}
\alias{enmtools.hypervolume}
\title{Takes an emtools.species object and environmental layers, and constructs a hypervolume using the R package hypervolume}
\usage{
enmtools.hypervolume(
  species,
  env,
  samples.per.point = 10,
  reduction.factor = 0.1,
  method = "gaussian",
  verbose = FALSE,
  clamp = TRUE,
  ...
)
}
\arguments{
\item{species}{An enmtools.species object}

\item{env}{A stack of environmental rasters}

\item{samples.per.point}{To be passed to hypervolume_gaussian}

\item{reduction.factor}{To be passed to hypervolume_project}

\item{method}{Method for constructing hypervolumes, defaults to "gaussian"}

\item{verbose}{Controls printing of various messages progress reports.  Defaults to FALSE.}

\item{clamp}{When set to TRUE, clamps the environmental layers so that predictions made outside the min/max of the training data for each predictor are set to the value for the min/max for that predictor. Prevents the model from extrapolating beyond the min/max bounds of the predictor space the model was trained in, although there could still be projections outside the multivariate training space if predictors are strongly correlated.}

\item{...}{Extra parameters to be passed to hypervolume_gaussian}
}
\value{
An enmtools hypvervolume object containing a hypervolume object, a raster of suitability scores, the species name, and the occurrence data frame.
}
\description{
Takes an emtools.species object and environmental layers, and constructs a hypervolume using the R package hypervolume
}
\examples{
\donttest{
install.extras(repos='http://cran.us.r-project.org')
data(euro.worldclim)
data(iberolacerta.clade)
env <- euro.worldclim[[c(1,8,12,17)]]
if(requireNamespace("hypervolume", quietly = TRUE)) {
    monticola.hv <- enmtools.hypervolume(iberolacerta.clade$species$monticola, env = env)
}
}
}
