% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R
\docType{class}
\name{ENMnull-class}
\alias{ENMnull-class}
\alias{ENMnull}
\alias{show,ENMnull-method}
\title{ENMnull class}
\usage{
\S4method{show}{ENMnull}(object)
}
\arguments{
\item{object}{ENMnull object}
}
\description{
An S4 class that contains the ENMnulls results.
}
\section{Slots}{

\describe{
\item{\code{null.algorithm}}{character: algorithm used}

\item{\code{null.mod.settings}}{data frame: model settings used}

\item{\code{null.partition.method}}{character: partition method used}

\item{\code{null.partition.settings}}{list: partition settings used (i.e., value of *k* or aggregation factor)}

\item{\code{null.doClamp}}{logical: whether to clamp model predictions or not}

\item{\code{null.other.settings}}{list: other modeling settings used (i.e., decisions about clamping, AUC diff calculation)}

\item{\code{null.no.iter}}{numeric: number of null model iterations}

\item{\code{null.results}}{data frame: evaluation summary statistics for null models}

\item{\code{null.results.partitions}}{data frame: evaluation k-fold statistics for null models}

\item{\code{null.emp.results}}{data frame: evaluation summary statistics for the empirical model, means for all null models, z-scores, and p-values}

\item{\code{emp.occs}}{data frame: occurrence coordinates and predictor variable values used for model training (empirical model)}

\item{\code{emp.occs.grp}}{vector: partition groups for occurrence points (empirical model)}

\item{\code{emp.bg}}{data frame: background coordinates and predictor variable values used for model training (empirical model)}

\item{\code{emp.bg.grp}}{vector: partition groups for background points (empirical model)}
}}

\author{
Jamie M. Kass, \email{jamie.m.kass@gmail.com}, Corentin Bohl, \email{corentinbohl@gmail.com}
}
