% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QRN.R
\name{QRN_seq_predict}
\alias{QRN_seq_predict}
\title{Predict function for a QRN_seq fitted object}
\usage{
QRN_seq_predict(
  fit_qrn_ts,
  X,
  Y,
  q_level = fit_qrn_ts$interm_lvl,
  crop_predictions = FALSE,
  device = default_device()
)
}
\arguments{
\item{fit_qrn_ts}{Fitted \code{"QRN_seq"} object.}

\item{X}{Matrix of covariates to predict the corresponding response's conditional quantiles.}

\item{Y}{Response variable vector corresponding to the rows of \code{X}.}

\item{q_level}{Optional, checks that \code{q_level == fit_qrn_ts$interm_lvl}.}

\item{crop_predictions}{Whether to crop out the fist \code{seq_len} observations (which are \code{NA}) from the returned matrix.}

\item{device}{(optional) A \code{\link[torch:torch_device]{torch::torch_device()}}. Defaults to \code{\link[=default_device]{default_device()}}.}
}
\value{
Matrix of size \code{nrow(X)} times \code{1}
(or \code{nrow(X)-seq_len} times \code{1} if \code{crop_predictions})
containing the conditional quantile estimates of the corresponding response observations.
}
\description{
Predict function for a QRN_seq fitted object
}
