% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EQRN.R
\name{instantiate_EQRN_network}
\alias{instantiate_EQRN_network}
\title{Instantiates the default networks for training a EQRN_iid model}
\usage{
instantiate_EQRN_network(
  net_structure,
  shape_fixed,
  D_in,
  hidden_fct,
  p_drop = 0,
  orthogonal_gpd = TRUE,
  device = default_device()
)
}
\arguments{
\item{net_structure}{Vector of integers whose length determines the number of layers in the neural network
and entries the number of neurons in each corresponding successive layer.}

\item{shape_fixed}{Whether the shape estimate depends on the covariates or not (bool).}

\item{D_in}{Number of covariates (including the intermediate quantile feature if used).}

\item{hidden_fct}{Activation function for the hidden layers. Can be either a callable function (preferably from the \code{torch} library),
or one of the the strings \code{"SNN"}, \code{"SSNN"} for self normalizing networks (with common or separated networks for the scale and shape estimates, respectively).
In the latter cases, \code{shape_fixed} has no effect.}

\item{p_drop}{Probability parameter for dropout before each hidden layer for regularization during training.
\code{alpha-dropout} is used with SNNs.}

\item{orthogonal_gpd}{Whether to use the orthogonal reparametrization of the estimated GPD parameters (recommended).}

\item{device}{(optional) A \code{\link[torch:torch_device]{torch::torch_device()}}. Defaults to \code{\link[=default_device]{default_device()}}.}
}
\value{
A \code{torch::nn_module} network used to regress the GPD parameters in \code{\link[=EQRN_fit]{EQRN_fit()}}.
}
\description{
Instantiates the default networks for training a EQRN_iid model
}
\keyword{internal}
