% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/status.R
\name{status}
\alias{status}
\title{True status definition}
\usage{
status(cases, r)
}
\arguments{
\item{cases}{the time series of the newly observed cases per unit of time (ideally per day).}

\item{r}{Definition for the minimum difference in the mean number of cases, one week before and after each time point that, if present, should be detected. This is the case definition and the default is 0.2 (with 0 <= r <= 1). A value of r=0.2 means that we have a case when the mean number of the newly observed cases in the next 7 days is at least 20\% higher than the mean number of the newly observed cases in the past 7 days.}
}
\value{
A vector of 0s and 1s is produced. Status = 1 is when the expected rise in the number of cases occurs and Status = 0 when the expected rise in the number of cases does not occur.
}
\description{
This function defines the true status based on the case definition.
}
\examples{
data("Italy")
cases = mova(cases=Italy$Cases)
status = status(cases=cases, r=0.2)
}
\references{
Kostoulas, P., Meletis, E., Pateras, K. et al. The epidemic volatility index, a novel early warning tool for identifying new waves in an epidemic. Sci Rep 11, 23775 (2021). \doi{10.1038/s41598-021-02622-3}
}
