% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multi_bound.R
\name{multi_bound}
\alias{multi_bound}
\title{Calculate a bound for the bias}
\usage{
multi_bound(
  biases,
  RRAUc = NULL,
  RRUcY = NULL,
  RRUsYA1 = NULL,
  RRSUsA1 = NULL,
  RRUsYA0 = NULL,
  RRSUsA0 = NULL,
  RRAUscS = NULL,
  RRUscYS = NULL,
  RRAYy = NULL,
  ORYAa = NULL,
  RRYAa = NULL,
  RRAYyS = NULL,
  ORYAaS = NULL,
  RRYAaS = NULL,
  RRAUsS = NULL,
  RRUsYS = NULL
)
}
\arguments{
\item{biases}{A set of biases (or single bias) to include in the calculation
of the bound. A single object constructed with the \code{\link[=multi_bias]{multi_bias()}} function,
it may include any or all of \code{\link[=confounding]{confounding()}}, \code{\link[=selection]{selection()}}, and
\code{\link[=misclassification]{misclassification()}}, and any of the options described in the
documentation for those functions.}

\item{RRAUc}{Named parameter values with which to calculate a bound. Names must
correspond to the parameters defining the biases provided by \code{biases}. Help
with names can be found by running \code{print(multi_bias(...))} for the biases
of interest. Unnecessary parameters are ignored with a warning.}

\item{RRUcY}{See \code{RRAUc}}

\item{RRUsYA1}{See \code{RRAUc}}

\item{RRSUsA1}{See \code{RRAUc}}

\item{RRUsYA0}{See \code{RRAUc}}

\item{RRSUsA0}{See \code{RRAUc}}

\item{RRAUscS}{See \code{RRAUc}}

\item{RRUscYS}{See \code{RRAUc}}

\item{RRAYy}{See \code{RRAUc}}

\item{ORYAa}{See \code{RRAUc}}

\item{RRYAa}{See \code{RRAUc}}

\item{RRAYyS}{See \code{RRAUc}}

\item{ORYAaS}{See \code{RRAUc}}

\item{RRYAaS}{See \code{RRAUc}}

\item{RRAUsS}{See \code{RRAUc}}

\item{RRUsYS}{See \code{RRAUc}}
}
\value{
Returns the value of the bound formed as a function of the provided
parameters.
}
\description{
Function used to calculate the maximum factor by which a risk
ratio is biased, given possible values for each of the parameters that
describe the bias factors for each type of bias.
}
\details{
The names of the parameters in the bound can be found for a given
set of biases with \code{print(biases)}. Running \code{summary(biases)} shows the
equivalent notation used in the output of the \code{\link[=multi_evalue]{multi_evalue()}} function.
}
\examples{
multi_bound(multi_bias(confounding()),
            RRAUc = 2.2, RRUcY = 1.7)

biases <- multi_bias(confounding(), selection("S = U"),
                     misclassification("exposure",
                     rare_outcome = TRUE, rare_exposure = FALSE))

print(biases)

multi_bound(biases,
            RRAUc = 3, RRUcY = 2, RRSUsA1 = 2.3,
            RRSUsA0 = 1.7, ORYAaS = 5.2)

}
\keyword{multi-bias}
