# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Matrix product
#'
#' Standard matrix product. The first matrix must have as many columns as the
#' second has rows.
#'
#' @param MAT1 matrix
#' @param MAT2 matrix
#'
#' @author Ehouarn Le Faou
#'
NULL

#' Matrix row bind
#'
#' Binding of two matrices by their row. Both matrices must have the same
#' number of rows.
#'
#' @param MAT1 matrix
#' @param MAT2 matrix
#'
#' @author Ehouarn Le Faou
#'
NULL

#' Importing the multinomial draw function from R into C++
#'
#' @param size number of random vectors to draw.
#' @param probs event probabilites
#' @param N number of trials
#'
#' @author Ehouarn Le Faou
#'
NULL

#' Multinomial draw
#'
#' @param n number of trials
#' @param size number of random vectors to draw.
#' @param probs event probabilites
#'
#' @author Ehouarn Le Faou
#'
NULL

#' Genetic drift
#'
#' Simulates genetic drift by drawing in a multinomial distribution with the
#' population size as the number of trials and the genotype frequencies as probabilities
#'
#' @param freq genotypic frequencies
#' @param N population size
#'
#' @author Ehouarn Le Faou
#'
NULL

#' Should the simulation stop?
#'
#' Determination from the allele frequencies if the simulation should stop.
#'
#' @param freqAlleles allelic frequencies
#' @param stopCondition list of stop conditions
#'
#' @author Ehouarn Le Faou
#'
NULL

#' What stop conditions has the simulation reached?
#'
#' Determination of the stop condition index or indices that the simulation
#' has reached.
#'
#' @param freqAlleles allelic frequencies
#' @param stopCondition list of stop conditions
#'
#' @author Ehouarn Le Faou
#'
NULL

#' Standardisation of a matrix
#'
#' Divides each cell of a matrix by its sum, so that the sum of all these
#' cells becomes 1.
#'
#' @param x matrix
#'
#' @author Ehouarn Le Faou
#'
NULL

#' Specify the seed for the RNG
#'
#' Sets the seed for random number generation to ensure repeatability of
#' simulations.
#'
#' @author Ehouarn Le Faou
#'
NULL

#' Crossing of male and female gametes
#'
#' Crossing of male and female gametes by knowing their respective genotype
#' frequencies and thanks to the crossing matrix which allows to determine
#' which genotypes result from each crossing between gametic haplotypes.
#'
#' @param nbHaplo number of haplotypes
#' @param nbGeno number of genotypes
#' @param freqHaploFemale female genotype frequencies
#' @param freqHaploMale male genotype frequencies
#' @param haploCrossMat haplotypes crossing matrix
#'
#' @author Ehouarn Le Faou
#'
NULL

#' Selfing
#'
#' Reproduction of the population by self-fertilization (only if the
#' population is hermaphroditic).
#'
#' @param nbHaplo number of haplotypes
#' @param nbGeno number of genotypes
#' @param freqGeno genotype frequencies
#' @param gametogenesisMat gametogenesis matrix
#' @param haploCrossMat haplotypes crossing matrix
#' @param femgamFit fitness of female gametes
#' @param malegamFit fitness of male gametes
#' @param femProdFit fitness for female gamete production
#' @param maleProdFit fitness for male gamete production
#'
#' @author Ehouarn Le Faou
#'
NULL

#' Outcrossing
#'
#' Reproduction of the population by outcrossing.
#'
#' @param nbHaplo number of haplotypes
#' @param nbGeno number of genotypes
#' @param freqGenoFemale female genotype frequencies
#' @param freqGenoMale male genotype frequencies
#' @param gametogenesisMat gametogenesis matrix
#' @param haploCrossMat haplotypes crossing matrix
#' @param femgamFit fitness of female gametes
#' @param malegamFit fitness of male gametes
#' @param femProdFit fitness for female gamete production
#' @param maleProdFit fitness for male gamete production
#'
#' @author Ehouarn Le Faou
#'
NULL

#' Reproduction of an hermaphroditic population
#'
#' Reproduction of a hermaphroditic population by selfing and outcrossing,
#' knowing their respective frequencies.
#'
#' @param nbHaplo number of haplotypes
#' @param nbGeno number of genotypes
#' @param selfRate selfing rate
#' @param freqGeno genotype frequencies
#' @param gametogenesisMat gametogenesis matrix
#' @param haploCrossMat haplotypes crossing matrix
#' @param femgamFit fitness of female gametes
#' @param malegamFit fitness of male gametes
#' @param femProdFit fitness for female gamete production
#' @param maleProdFit fitness for male gamete production
#'
#' @author Ehouarn Le Faou
#'
NULL

#' Reproduction of a dioecious population
#'
#' @param nbHaplo number of haplotypes
#' @param nbGeno number of genotypes
#' @param freqGenoFemale female genotype frequencies
#' @param freqGenoMale male genotype frequencies
#' @param gametogenesisMat gametogenesis matrix
#' @param haploCrossMat haplotypes crossing matrix
#' @param femgamFit fitness of female gametes
#' @param malegamFit fitness of male gametes
#' @param femProdFit fitness for female gamete production
#' @param maleProdFit fitness for male gamete production
#'
#' @author Ehouarn Le Faou
#'
NULL

#' Selection on individuals
#'
#' Selection on individuals (selection on gametes and gamete production is
#' carried out during reproduction).
#'
#' @param nbGeno number of genotypes
#' @param freqGeno genotype frequencies
#' @param fitness fitness of individuals
#'
#' @author Ehouarn Le Faou
#'
NULL

#' Simulate the model
#'
#' @param recording a boolean indicating whether to record all mutations, i.e.
#' to record allelic and genotypic frequencies along the simulations
#' @param recordGenGap the number of generations between two records during
#' simulation, if the record parameter is TRUE. Whatever the value of this
#' parameter, both the first and the last generation will be included in
#' the record
#' @param drift a boolean indicating whether genetic drift should be
#' considered (i.e. whether deterministic simulations are performed or not)
#' @param nbHaplo number of haplotypes
#' @param nbGeno number of genotypes
#' @param nbAlleles number of alleles for each loci
#' @param initGenoFreq initial genotype frequencies
#' @param gametogenesisMat gametogenesis matrix
#' @param N population size
#' @param threshold threshold for simulations
#' @param dioecy whether the population is dioecious or not (hermaphrodism)
#' @param selfRate selfing rate (only for hermaphroditic population)
#' @param stopCondition list of stop conditions
#' @param haploCrossMat haplotypes crossing matrix
#' @param alleleFreqMat matrix for calculating allelic frequencies
#' @param femgamFit fitness of female gametes
#' @param malegamFit fitness of male gametes
#' @param femindFit fitness of female individuals
#' @param maleindFit fitness of male individuals
#' @param indFit fitness of individuals (only for hermaphroditic population)
#' @param femProdFit fitness for female gamete production
#' @param maleProdFit fitness for male gamete production
#'
#' @author Ehouarn Le Faou
#'
NULL

#' Simulate the model multiple times
#'
#' Simulation of the model multiple times with all the necessary parameters
#' set.
#'
#' @param nsim number of simulations
#' @param recording a boolean indicating whether to record all mutations, i.e.
#' to record allelic and genotypic frequencies along the simulations
#' @param recordGenGap the number of generations between two records during
#' simulation, if the record parameter is TRUE. Whatever the value of this
#' parameter, both the first and the last generation will be included in
#' the record
#' @param drift a boolean indicating whether genetic drift should be
#' considered (i.e. whether deterministic simulations are performed or not)
#' @param nbHaplo number of haplotypes
#' @param nbGeno number of genotypes
#' @param nbAlleles number of alleles for each loci
#' @param initGenoFreq initial genotype frequencies
#' @param gametogenesisMat gametogenesis matrix
#' @param N population size
#' @param threshold threshold for simulations
#' @param dioecy whether the population is dioecious or not (hermaphrodism)
#' @param selfRate selfing rate (only for hermaphroditic population)
#' @param stopCondition list of stop conditions
#' @param haploCrossMat haplotypes crossing matrix
#' @param alleleFreqMat matrix for calculating allelic frequencies
#' @param femgamFit fitness of female gametes
#' @param malegamFit fitness of male gametes
#' @param femindFit fitness of female individuals
#' @param maleindFit fitness of male individuals
#' @param indFit fitness of individuals (only for hermaphroditic population)
#' @param femProdFit fitness for female gamete production
#' @param maleProdFit fitness for male gamete production
#' @param verbose boolean determining if the progress of the simulations should be displayed or not (useful in case of many simulations)
#'
#' @return Each simulation is described by data.frame where each line corresponds to a generation (by default,
#' otherwise according to the \code{recordGenGap} parameter of the \code{simulate} method). The first one(s) describe(s)
#' the genotypic frequencies at the end of the simulations of the individuals in the case of a hermaphroditic population
#' or of the females then of the males in the case of a dioecious population. Then there are in order: the allelic
#' frequencies at the end of the simulations, the generations where the simulations stopped, the stop conditions reached.
#' Then there are the lists of records where each simulation is described by a data.frame where each line is a generation.
#' The record lists correspond to the genotypic frequencies, the allelic frequencies and finally the generations.
#' 
#' @author Ehouarn Le Faou
#'
SIMULATION_MULTIPLE <- function(nsim, recording, recordGenGap, drift, nbHaplo, nbGeno, nbAlleles, initGenoFreq, gametogenesisMat, N, threshold, dioecy, selfRate, stopCondition, haploCrossMat, alleleFreqMat, femgamFit, malegamFit, femindFit, maleindFit, indFit, femProdFit, maleProdFit, verbose) {
    .Call(`_Ease_SIMULATION_MULTIPLE`, nsim, recording, recordGenGap, drift, nbHaplo, nbGeno, nbAlleles, initGenoFreq, gametogenesisMat, N, threshold, dioecy, selfRate, stopCondition, haploCrossMat, alleleFreqMat, femgamFit, malegamFit, femindFit, maleindFit, indFit, femProdFit, maleProdFit, verbose)
}

