% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DiscrepancyPrior-ShaSTPrior-class.R
\docType{class}
\name{ShaSTPrior-class}
\alias{ShaSTPrior-class}
\title{A class to hold the priors for the ensemble model.}
\description{
An \code{ShaSTPrior} object encapsulates the prior information for the short-term discrepancies of the shared discrepancy of the ensemble model.
}
\details{
Shared short-term discrepancies \eqn{\mathbf{\eta}^{(t)}} are modelled as an AR(1) process so that \deqn{\mathbf{\eta}^{(t+1)} \sim N(R_\eta \mathbf{\eta}, \Lambda_\eta).} Accepted parametrisation forms for this discrepancy are \code{lkj}, \code{beta}, or \code{inv_wishart}. See details of the \code{EnsemblePrior()} constructor for more details.
}
\section{Slots}{

\describe{
\item{\code{AR_param}}{The parameters giving the beta parameters for the main parameter of the AR(1) process.}

\item{\code{parametrisation_form}}{The parametrisation by which the covariance matrix of the noise of the AR process is decomposed.}

\item{\code{var_params}}{The parameters characterising the variance of the AR process on the shared short-term discrepancy.}

\item{\code{cor_params}}{The parameters characterising the correlations of the AR process on the shared short-term discrepancy.}
}}

