% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classifier_test.R
\name{classifier_test}
\alias{classifier_test}
\title{Classifier k-sample test}
\usage{
classifier_test(
  x,
  y,
  split = 0.7,
  thresh = 0,
  method = "knn",
  control = caret::trainControl(method = "cv"),
  ...
)
}
\arguments{
\item{x}{Samples from the first distribution or a list of samples
from k distribution}

\item{y}{Samples from the second distribution. Only used if x is a vector.}

\item{split}{How to split the data between training and test. Default to .7}

\item{thresh}{Value to add to the null hypothesis. See details.}

\item{method}{Which model(s) to use during training. Default to knn.}

\item{control}{Control parameters when fitting the methods.
See \link[caret]{trainControl}}

\item{...}{Other parameters passed to \link[caret]{train}}
}
\value{
A list containing the following components:
\itemize{
\item \emph{statistic} the value of the test statistic.
\item \emph{p.value} the p-value of the test.
}
}
\description{
Classifier k-sample test
}
\details{
See Lopez-Paz et .al for more background on those tests.
}
\examples{
 x <- matrix(c(runif(100, 0, 1),
               runif(100, -1, 1)),
             ncol = 2)
 y <- matrix(c(runif(100, 0, 3),
               runif(100, -1, 1)),
             ncol = 2)
 classifier_test(x, y)
}
\references{
Lopez-Paz, D., & Oquab, M. (2016). Revisiting Classifier Two-Sample Tests, 1–15. Retrieved from http://arxiv.org/abs/1610.06545
}
